<!--  ##### REGISTRATION PAGE #####  -->

<?php
// MYSQL DATABASE CONNECTION
require "database/connection.php";
//DECLARING VARIABLES
$fullname=$username=$mobilenumber=$email=$password="";
//DECLARING ERROR VARIABLES
$femptyerror=$fsizeerror=$fpatternerror=$uemptyerror=$usizeerror=$upatternerror=$memptyerror=$msizeerror=$mpatternerror=$eemptyerror=$esizeerror=$epatternerror=$pemptyerror=$psizeerror=$ppatternerror=$duplicatmailerror=$successmessage=$failedmessage="";
// CHECK FOR SUBMIT BUTTON SET
if(isset($_POST["submit"])){
    $fullname=mysqli_real_escape_string($connection,trim($_POST["fullname"]));
    $username=mysqli_real_escape_string($connection,trim($_POST["username"]));
    $mobilenumber=mysqli_real_escape_string($connection,trim($_POST["mobilenumber"]));
    $email=mysqli_real_escape_string($connection,trim($_POST["email"]));
    $password=mysqli_real_escape_string($connection,trim($_POST["password"]));
    //DECLARING VALID VARIABLES
    $fullnamevalid=$usernamevalid=$mobilenumbervalid=$emailvalid=$passwordvalid=false;
    //CHECK FOR FULLNAME
    if(!empty($fullname)){
        if(strlen($fullname) > 1 && strlen($fullname) < 51){
            if(!preg_match("/[^a-zA-Z\s]/",$fullname)){
                $fullnamevalid=true; 
                 $fullname= $_POST["fullname"];             
            }else{                
                $fpatternerror="Full Name contains Alphabets only !";
            }
        }else{            
            $fsizeerror="Fullname contains between 2 and 50 characters long !";
        }
    }else{        
        $femptyerror="Fullname can not be Blank !";
    }

    //CHECK FOR USERNAME
    if(!empty($username)){
        if(strlen($username) >= 2 && strlen($username) <= 15){
            if(!preg_match("/[^a-zA-Z\d_]/",$username)){
                    $usernamevalid=true;
                    $username=$_POST["username"];                
            }else{                
                    $upatternerror="Username contains Alphabets, Digits, Underscore only !";
                }
        }else{            
                $usizeerror="Username contains between 2 and 15 characters long !";
            }
    }else{        
            $uemptyerror="Username can not be Blank !";
        }

    //CHECK FOR MOBILENUMBER
    if(!empty($mobilenumber)){
        if(strlen($mobilenumber) == 10){
            if(preg_match("/^[6789][0-9]{9}/",$mobilenumber)){
                $mobilenumbervalid=true;
                $mobilenumber=$_POST["mobilenumber"];                
            }else{                
                $mpatternerror="Mobile Number contains numbers & start with Digits 6,7,8 and 9 only !";
            }
        }else{            
            $msizeerror="Mobile Number must be 10 characters long!";
        }
    }else{        
        $memptyerror="Mobile Number can not be Blank!";
    }

    //CHECK FOR EMAIL
    if(!empty($email)){
        if(strlen($email) > 1 && strlen($email) < 51){
            if(filter_var($email, FILTER_VALIDATE_EMAIL)){
                $emailvalid=true;
                $email=$_POST["email"];                
            }else{                
                $epatternerror="Invalid Email!";
            }
        }else{            
            $esizeerror="Email must be between 2 and 50 characters long!";
        }
    }else{        
        $eemptyerror="Email can not be Blank!";
    }

    //CHECK FOR PASSWORD
    if(!empty($password)){
        if(strlen($password) >= 5 && strlen($password) <= 15){
            if(!preg_match("/[^a-zA-Z\d@_-]/",$password)){
                $passwordvalid=true;
                $password=$_POST["password"];
                $hashpassword=password_hash($password,PASSWORD_DEFAULT);                
            }else{                
                $ppatternerror="Password contains Alphabets, Digits, @ symbol, Underscore and Hyphen only!";
            }
        }else{            
            $psizeerror="Password must be between 5 and 15 characters long!";
        }
    }else{        
        $pemptyerror="Password can not be Blank!";
    }

    //CHECK FOR ALL VALID FIELDS ARE TRUE
    if($fullnamevalid && $usernamevalid && $mobilenumbervalid && $emailvalid && $passwordvalid == true ){
              //### CHECK FOR DUPLICATE EMAIL ID WHILE REGISTRATION
              $emailcheckquery="SELECT * FROM registration WHERE mail='$email'";
              $emailcheckqueryexecute=mysqli_query($connection,$emailcheckquery);
              $emailcount=mysqli_num_rows($emailcheckqueryexecute);
              if($emailcount > 0){
                $duplicatmailerror="Email Already Exist!";
              }else {
                  //### SAVING FORM DATA TO THE DATABASE
                  $insertquery="INSERT INTO registration (name,uname,contact,mail,upassword) VALUES ('$fullname','$username','$mobilenumber','$email','$hashpassword')";
                  $insertqueryexecute=mysqli_query($connection,$insertquery);
                  if($insertqueryexecute){
                    $successmessage="Registered Successfully.Your Login Details has been sent to the Registered Email.";
                      
                      //### SENDING MAIL TO THE REGISTERED USER 
                      $html="<p>Dear&nbsp;<strong>$fullname</strong></p><p><strong>Thanks!&nbsp;</strong>For the Registration in <strong>QuizApp</strong>. Please see the your Login Credentials Details below:</p><table><tr><td>Username:</td><td>$username</td></tr><tr><td>Email:</td><td>$email</td></tr><tr><td>Password:</td><td>$password</td></tr></table><br><br><br>Thanks & Regards<br><span style='color:red; font-style:italic; font-size:25px; font-weight:bold;'>QuizApp</span>";
                      include('smtp/PHPMailerAutoload.php');
                      $mail=new PHPMailer(true);
                      $mail->isSMTP();
                      $mail->Host="smtp.gmail.com";
                      $mail->Port=587;
                      $mail->SMTPSecure="tls";
                      $mail->SMTPAuth=true;
                      $mail->Username="helloquizapp@gmail.com";
                      $mail->Password="quizapp@12345";
                      $mail->SetFrom("helloquizapp@gmail.com");
                      $mail->addAddress($email);
                      $mail->IsHTML(true);
                      $mail->Subject="Login Details";
                      $mail->Body=$html;
                      $mail->SMTPOptions=array('ssl'=>array(
                          'verify_peer'=>false,
                          'verify_peer_name'=>false,
                          'allow_self_signed'=>false
                      ));
                      if($mail->send()){
                          // echo "Mail send";
                                             
                      }else{
                          echo "Error occur";
                      }
                         
                  
                  }else {
                    
                    $failedmessage="Registration Failed!";

                  }
              }
    }
}

?>

<!-- HTML MARKUP FOR REGISTRATION PAGE DESIGN-->
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
    <link href="https://fonts.googleapis.com/css2?family=Josefin+Slab:ital,wght@1,600&family=Lobster&family=Montserrat:ital,wght@1,900&family=Pacifico&display=swap" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <title>Registration</title>
</head>
<body class="text-center">
    <div class="cover-container d-flex w-100 h-100 p-3 mx-auto flex-column">
        <!--HEADER SECTION-->
        <header class="masthead mb-auto">
            <div class="inner">
                <h3 class="masthead-brand"><a href="index.php" class="text-danger">QuizApp</a></h3>
                <nav class="nav nav-masthead justify-content-center">
                    <a class="nav-link" href="index.php">Home</a>
                    <a class="nav-link" href="login.php">Login</a>
                    <a class="nav-link" href="registration.php">Register</a>
                </nav>
            </div>
        </header>

        <!--MAIN SECTION --> 
              
        <main role="main">        
        <div class="signup-form">	
        <form action="<?php  echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" method="POST" id="regform">    <!-- <div class='alert alert-danger'><?php //echo $duplicatmailerror; ?></div> -->
         <span style="color:red; font-size:larger;"><?php echo $duplicatmailerror; ?></span>
         <span style="color:green; font-size:larger;"><?php echo $successmessage; ?></span>
         <span style="color:red; font-size:larger;"><?php echo $failedmessage; ?></span>
		<h2>Register</h2>
		 <div class="form-group">
			<div class="input-group">
				<span class="input-group-addon"><i class="fa fa-user-circle-o"></i></span>
				<input type="text" class="form-control" name="fullname" placeholder="FullName *">    <!-- value="<?php //echo htmlspecialchars($fullname); ?>" required pattern="^[a-zA-Z\s]+$" title="Contain lowercase, uppercase alphabets only."-->
            </div>
            <!-- DISPLAY FULLNAME ERROR MESSAGE ON FORM -->
            <span style="color:red;"><?php echo $femptyerror; echo $fsizeerror; echo $fpatternerror; ?></span>
        </div>        
        
        <div class="form-group">
			<div class="input-group">
				<span class="input-group-addon"><i class="fa fa-user"></i></span>
				<input type="text" class="form-control" name="username" placeholder="Username *" >      <!--  value="<?php //echo htmlspecialchars($username); ?>"  required pattern="^[a-z0-9_-]{3,15}$" title="Username should contain lowercase, digit, underscore, hyphen only.Length between 3 and 15 characters."-->
    		</div>
        <!-- DISPLAY USERNAME ERROR MESSAGE ON FORM -->
        <span style="color:red;"><?php echo $uemptyerror; echo $usizeerror; echo $upatternerror; ?></span>
        </div>
        <div class="form-group">
			<div class="input-group">
				<span class="input-group-addon"><i class="fa fa-phone"></i></span>
				<input type="text" class="form-control" name="mobilenumber" placeholder="Mobile Number *">   <!--  value="<?php //echo htmlspecialchars($mobilenumber); ?>" required pattern="^[6789][0-9]{9}" title="Start with first digit between 6 and 9 only.Must contain total 10 digits."-->
    		</div>
        <!-- DISPLAY MOBILENUMBER ERROR MESSAGE ON FORM -->
        <span style="color:red;"><?php echo $memptyerror; echo $msizeerror; echo $mpatternerror; ?></span>
        </div> 
        <div class="form-group">
			<div class="input-group">
				<span class="input-group-addon"><i class="fa fa-paper-plane"></i></span>
				<input type="text" class="form-control" name="email" placeholder="Email Address *">    <!-- value="<?php //echo htmlspecialchars($email); ?>" required pattern="/^[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$/  or [a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2, 4}$"-->
            </div>
        <!-- DISPLAY EMAIL ERROR MESSAGE ON FORM -->    
        <span style="color:red;"><?php echo $eemptyerror; echo $esizeerror; echo $epatternerror; ?></span>
        </div>
		<div class="form-group">
			<div class="input-group">
				<span class="input-group-addon"><i class="fa fa-lock"></i></span>
				 <input type="password" class="form-control" name="password" placeholder="Password *">   <!--  value="<?php //echo htmlspecialchars($password); ?>"  required pattern="^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#$%^&*_=+-]).{8,12}$" title="Mixed of Lowercase,Uppercase,Number and Symbols.Minimum 8 & Maximum 12 characters." -->
        	</div>
        <!-- DISPLAY PASSWORD ERROR MESSAGE ON FORM -->
        <span style="color:red;"><?php echo $pemptyerror; echo $psizeerror; echo $ppatternerror; ?></span>
        </div>
		<!-- DISABLED BUTTON AND CALLING FUNCTION ONCLICK EVENT ON CLICKING SUBMIT BUTTON WHILE SUBMITTING FORM -->
		<div class="form-group">
            <button disabled class="btn btn-success btn-lg" type="button" id="sbtn2" style="display:none;">Please wait.....</button>
            <button type="submit" name="submit" id="sbtn" class="btn btn-success btn-lg" onclick="save();">Submit</button>
        </div>
		
    </form>
 
	<div class="text-center text-light">Already have an account? <a href="login.php" class="text-primary">Login here</a>.</div>
</div>
        </main>
        <!-- FOOTER SECTION -->
        <footer class="mastfoot mt-auto">
            <div class="inner">
                <p> Made with <span style="color:red;">&hearts;</span> Developed by <a href="https://www.facebook.com" class="text-warning">Subodh</a>.</p>
            </div>
        </footer>
    </div>

      <!-- DISPLAY PLEASE WAIT MESSAGE WHILE SUBMITTING FORM -->
    <script type="text/javascript">
        function save(){
        $("#sbtn").hide();
        $("#sbtn2").show();
    }
    // PREVENT CONFIRM FORM RESUBMISSION ON PAGE REFRESH OR RELOAD 
    if ( window.history.replaceState ) {
        window.history.replaceState( null, null, window.location.href );
    }
    </script>
    
    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>

</body>
</html>
