<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(env('APP_NAME')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- ============== favicons =========== -->
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/img/favicon/favicon.png')); ?>">

    <!-- ======= CSS Plugins here ======== -->
    <link
        href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900&amp;family=Lora:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&amp;family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap"
        rel="stylesheet">

    <!-- =========== Plugin CSS =============== -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/admin/css/vendor/bootstrap.min.css')); ?>">

    <!-- ========= IconFont CSS ===========-->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/admin/css/icofont.min.css')); ?>">

    <!-- =========== Custom Style CSS ========= -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/admin/css/style.css')); ?>">

    <?php echo $__env->yieldContent('style'); ?>

    <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script> -->
    <script src="<?php echo e(asset('/assets/admin/js/jquery-3.6.0.min.js')); ?>"></script>

    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <!-- Html Editor -->
    <script src="https://unpkg.com/react@17.0.2/umd/react.production.min.js"></script>
    <script src="https://unpkg.com/react-dom@17.0.2/umd/react-dom.production.min.js"></script>
    <link rel="stylesheet" href="<?php echo e(asset('public/vendor/laraberg/css/laraberg.css')); ?>">
    <script src="<?php echo e(asset('public/vendor/laraberg/js/laraberg.js')); ?>"></script>
    <!-- End Html Editor -->

    <script type="text/javascript">
        $(document).ready(function() {
            if ($(window).width() > 570) {
                $('.header__section').css('margin-bottom', $('.header__sticky').height() + 40 + 'px');
            } else {
                $('.header__section').css('margin-bottom', $('.header__sticky').height() + 20 + 'px');
            }

            if ($(window).width() > 570) {
                $('.shop__sidebar--widget').css('top', $('.header__sticky').height() + 40 + 'px');
            }



        });
    </script>
</head>

<body class="admin-bg">

    <!-- Start offcanvas filter sidebar -->
    <div class="offcanvas__filter--sidebar widget__area">
        <button type="button" class="offcanvas__filter--close" data-offcanvas>
            <svg class="minicart__close--icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                <path fill="currentColor" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                    stroke-width="32" d="M368 368L144 144M368 144L144 368"></path>
            </svg> <span class="offcanvas__filter--close__text">Close</span>
        </button>
        <div class="offcanvas__filter--sidebar__inner">
            <div class="single__widget widget__bg">
                <h2 class="widget__title h3">Admin Controllers</h2>
                <?php echo $__env->make('admin.layouts.admin_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
    <!-- End offcanvas filter sidebar -->


    <!-- Start header area -->
    <header class="header__section border-bottom">

        <div class="main__header header__sticky sticky"
            style="background-color:white; box-shadow: 0 0 7px rgb(0 0 0 / 15%);">
            <div class="container-fluid">
                <div class="main__header--inner position__relative d-flex justify-content-between align-items-center">

                    <button class="widget__filter--btn d-flex d-lg-none align-items-center border-0" data-offcanvas="">
                        <svg xmlns="http://www.w3.org/2000/svg" class="ionicon offcanvas__header--menu__open--svg"
                            viewBox="0 0 512 512">
                            <path fill="currentColor" stroke="currentColor" stroke-linecap="round"
                                stroke-miterlimit="10" stroke-width="32" d="M80 160h352M80 256h352M80 352h352" />
                        </svg>
                    </button>

                    <div class="main__logo">
                        <h2 class="main__logo--title"><a class="main__logo--link" href="<?php echo e(route('dashboard')); ?>">
                                Admin</a>
                        </h2>
                    </div>
                    <div class="header__account header__sticky">
                        <ul class="d-flex">

                            <li class="header__account--items">

                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <input type="submit" value="Logout">

                                </form>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

    </header>
    <!-- End header area -->


    <!-- ====== Main Content Start ===== -->
    <main class="main__content_wrapper">
        <section class="shop__section mt-sm-5">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-3 col-lg-4">
                        <div class="shop__sidebar--widget widget__area d-none d-lg-block">
                            <div class="single__widget widget__bg bg-white">
                                <h2 class="widget__title h3">Admin Control</h2>
                                <?php echo $__env->make('admin.layouts.admin_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-9 col-lg-8 pp-sm mm-top">
                        <?php echo $__env->yieldContent('main-content'); ?>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!-- ====== Main Content End ===== -->

    <!-- Start footer section -->
    <footer class="footer__section footer__bg" style="margin-top: 200px;">
        <div class="container">
            <div class="py-4">
                <div class="row">
                    <div class="col-12 text-center">
                        <p class="copyright__content">Copyright © 2022 <a class="copyright__content--link text__primary"
                                href="https://www.jharkhanditservices.com/" target="_blank">Jharkhand IT Service
                                Software Pvt. Ltd.</a> . All Rights Reserved.</p>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- End footer section -->

    <!-- Scroll top bar -->
    <button id="scroll__top"><svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512">
            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="48"
                d="M112 244l144-144 144 144M256 120v292" />
        </svg></button>

    <!-- All Script JS Plugins here  -->

    <script src="<?php echo e(asset('/assets/admin/js/vendor/bootstrap.min.js')); ?>" defer="defer"></script>

    <!-- Customscript js -->
    <script src="<?php echo e(asset('/assets/admin/js/script.js')); ?>"></script>

    <!-- ======== My JS Classes ========== -->
    <script src="<?php echo e(asset('/assets/admin/js/classes.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/admin/js/service.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/admin/js/main.js')); ?>"></script>


    <?php echo $__env->yieldContent('script'); ?>

</body>

</html>
<?php /**PATH D:\xampp projects\newblog\resources\views/admin/layouts/admin_layout.blade.php ENDPATH**/ ?>