<?php $__env->startSection('title', env('APP_NAME')); ?>
<?php $__env->startSection('main-content'); ?>

    <style>
        .imgc {
            margin-top: 20px;
            position: relative;
            width: 100%;
            height: 170px;
            background: rgb(197, 197, 197);
        }

        .imgc img {
            width: 100%;
            height: 168px;
        }

        .imgc .btn {
            position: absolute;
            top: 8%;
            left: 98%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            background-color: red;
            color: white;
            font-size: 10px;
            border-radius: 50%;
            cursor: pointer;
            text-align: center;
        }

        .imgc .btn:hover {

            background-color: red;
            color: #fff;
            font-size: 16px;
        }

        .imgc:hover {
            cursor: pointer;
            transform: translate(-1%, -1%);
            border: 1px solid red;
        }
    </style>

    <div class="admin-container">
        <?php
            $tbx['tb'] = true;
            $tbx['back-btn'] = route('post.index');
            $tbx['title'] = 'Edit Post';
            $route_name = 'post';
            $image_dir = 'assets/img/post/';
        ?>
        <?php echo $__env->make('admin.includes.title-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form class="row" action="<?php echo e(route($route_name . '.store')); ?>" enctype="multipart/form-data" id="myForm"
            method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" value="UPDATE" name="action">
            <input type="hidden" value="<?php echo e($data->id); ?>" name="id">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-12">
                        <label for="" class="form-label">Title</label>
                        <input type="text" class="form-control" name="title" value="<?php echo e($data->title); ?>">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Slug</label>
                        <input type="text" class="form-control" readonly value="<?php echo e($data->slug); ?>">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Meta Title</label>
                        <input type="text" class="form-control" name="meta_title" value="<?php echo e($data->meta_title); ?>">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Meta Description</label>
                        <textarea class="form-control" rows="2" name="meta_description"><?php echo e($data->meta_description); ?></textarea>
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Meta Keywords</label>
                        <input type="text" class="form-control" name="meta_keywords" value="<?php echo e($data->meta_keywords); ?>">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Meta Author Name</label>
                        <input type="text" class="form-control" name="author_name" value="<?php echo e($data->author_name); ?>">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Content</label>
                        <textarea class="form-control" id="html_content" name="content" hidden><?php echo e($data->content); ?></textarea>
                    </div>

                    <div class="col-sm-4">
                        <label for="" class="form-label">Category</label>
                        <?php echo $__env->make('admin.includes.post-categories', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-label">Status</label>
                        <?php echo $__env->make('admin.includes.select-status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-md-6">
                        
                        <?php
                            $image_path = $data->image == null ? 'assets/img/post/dummy-image.png' : 'assets/img/post/' . $data->image;
                            
                        ?>

                        <div class="imgc">
                            <img id="img1" src="<?php echo e(asset($image_path)); ?>" alt="img">
                            <input accept="image/*" type="file" name="file1" id="file1" hidden />
                            <button type="button" id="delete1" class="btn"> <i class="icofont-trash"></i></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                
                <button type="submit" name="submit" class="btn btn-primary fs-4 mt-4 disable_btn">
                    Update
                </button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            Laraberg.init('html_content');
            document.querySelector(
                "#myForm > div.col-md-12 > div > div:nth-child(7) > div > div > div > div.block-editor__header > div:nth-child(2) > button"
            ).click();
        });


        if ($('#img1').attr('src') == "<?php echo e(url('assets/img/post/dummy-image.png')); ?>") {
            $("#delete1").hide();
        }

        $("#img1").click(function() {
            $("#file1").val(null);
            $('#file1').click();
        });

        $("#file1").change(function() {

            var tmpath = URL.createObjectURL(this.files[0]);

            $('#img1').attr('src', tmpath);
            $("#delete1").show();

        });

        $("#delete1").click(function() {
            $("#delete1").hide();
            $('#img1').attr('src', "<?php echo e(url('assets/img/post/dummy-image.png')); ?>");
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\salon\resources\views/admin/post/edit.blade.php ENDPATH**/ ?>