<?php $__env->startSection('title', env('APP_NAME')); ?>
<?php $__env->startSection('main-content'); ?>
    <div class="admin-container">
        <?php
            $tbx['tb'] = 1;
            $tbx['title'] = 'Slider List';
            $tbx['btn-name'] = 'Add';
            $tbx['btn-link'] = route('slider.create');
            $tbx['search-bar'] = true;

            $route_name = 'slider';
            $image_dir = 'assets/img/slider/';
        ?>

        <?php echo $__env->make('admin.includes.title-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="cart__table">
            <table class="cart__table--inner">
                <thead class="cart__table--header">
                    <tr class="cart__table--header__items">
                        <th class="cart__table--header__list">Slider</th>
                        <th class="cart__table--header__list">Status</th>
                        <th class="cart__table--header__list text-center">Reorder</th>
                        <th class="cart__table--header__list text-right">Action</th>
                    </tr>
                </thead>
                <tbody class="cart__table--body" id="slider-list">
                    <?php $__currentLoopData = $data_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="cart__table--body__items">
                            <td class="cart__table--body__list">
                                <div class="cart__product d-flex align-items-center">
                                    <div class="cart__thumbnail">
                                        <?php echo $__env->make('admin.includes.thumbnail', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="cart__content">
                                        <h3 class="cart__content--title h4">
                                            <a href="#"><?php echo e(Str::words($data->slider_name, 7, '...')); ?></a>
                                        </h3>
                                        <span class="cart__content--variant">
                                            <?php echo e(Str::words($data->title, 7, '...')); ?>

                                        </span>
                                    </div>
                                </div>
                            </td>
                            <td class="cart__table--body__list">
                                <?php echo $__env->make('admin.includes.status-button', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </td>
                            <td class="cart__table--body__list text-center">
                                <?php echo $__env->make('admin.includes.reorder-input', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </td>

                            <td class="cart__table--body__list text-right">
                                <?php echo $__env->make('admin.includes.edit-button', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('admin.includes.delete-button', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="col-12">
                
            </div>
        </div>
    </div>

<?php $__env->startSection('script'); ?>
    <script>
        function changeStatus(selector, id) {
            let api = new ApiService();
            let status = $(selector).prop('checked') == true ? 1 : 0;
            let sid = id;
            // let action = "UPDATE_STATUS"
            console.log(selector.value, status);
            // if(selector)
            let data = {
                'id': sid,
                'status': status,
                "action": "UPDATE_STATUS"
            };

            let req = api.setData("slider/statusUpdate", data);
            console.log(req);

            req.then((res) => {

                console.log(res);
                // if (res.status == true) {
                //     alert('ok');
                // } else {
                //     alert(res.message);
                // }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\newblog\resources\views/admin/slider/index.blade.php ENDPATH**/ ?>