<?php $__env->startSection('title', env('APP_NAME')); ?>
<?php $__env->startSection('main-content'); ?>


    <div class="admin-container">
        <?php
            $tbx['tb'] = true;
            $tbx['back-btn'] = route('slider.index');
            $tbx['title'] = 'Edit Slider';
            $route_name = 'slider';
            $image_dir = 'assets/img/slider/';
        ?>
        <?php echo $__env->make('admin.includes.title-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form class="row" method="POST" action="<?php echo e(route($route_name . '.store')); ?>" enctype="multipart/form-data"
            id="myForm">
            <?php echo csrf_field(); ?>
            <input type="hidden" value="UPDATE" name="action">
            <input type="hidden" value="<?php echo e($data->id); ?>" name="id">
            <div class="col-md-7">
                <div class="col-12">
                    <label for="" class="form-label">Slider Name</label>
                    <input type="text" class="form-control" value="<?php echo e($data->slider_name); ?>" name="slider_name">
                </div>
                <div class="col-12">
                    <label for="" class="form-label">Title</label>
                    <input type="text" class="form-control" value="<?php echo e($data->title); ?>" name="title">
                </div>
                <div class="col-12">
                    <label class="form-label">Description</label>
                    <textarea class="form-control" name="description"><?php echo e($data->description); ?></textarea>
                </div>
                <div class="col-12">
                    <label class="form-label">Button Name</label>
                    <input type="text" class="form-control" value="<?php echo e($data->button_name); ?>" name="button_name">
                </div>
                <div class="col-12">
                    <label class="form-label">Button Link</label>
                    <input type="text" class="form-control" value="<?php echo e($data->button_link); ?>" name="button_link">
                </div>
                <div class="col-12">
                    <label for="inputState" class="form-label">Slider Order</label>
                    <input type="text" class="form-control" value="<?php echo e($data->serial_no); ?>" name="serial_no">
                </div>
                <div class="col-12">
                    <label for="" class="form-label">Status</label>
                    <?php echo $__env->make('admin.includes.select-status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            <div class="col-md-5">
                
                <div class="imgc">
                    <img id="img1" src="<?php echo e(asset('assets/img/slider/dummy-image.png')); ?>" alt="img">
                    <input accept="image/*" type="file" name="file1" id="file1" hidden />
                    <button type="button" id="delete1" class="btn"> <i class="icofont-trash"></i></button>
                </div>
            </div>
            <div class="col-12">
                
                <button type="submit" class="btn btn-primary fs-4 mt-4 disable_btn">
                    Update
                </button>
            </div>
        </form>

    </div>

<?php $__env->startSection('script'); ?>
    <script>
        if ($('#img1').attr('src') == "<?php echo e(url('assets/img/slider/dummy-image.png')); ?>") {
            $("#delete1").hide();
        }

        $("#img1").click(function() {
            $("#file1").val(null);
            $('#file1').click();
        });

        $("#file1").change(function() {

            var tmpath = URL.createObjectURL(this.files[0]);

            $('#img1').attr('src', tmpath);
            $("#delete1").show();

        });

        $("#delete1").click(function() {
            $("#delete1").hide();
            $('#img1').attr('src', "<?php echo e(url('assets/img/slider/dummy-image.png')); ?>");
        });
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\newblog\resources\views/admin/slider//edit.blade.php ENDPATH**/ ?>