<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PostCategoryController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\TestimonialController;
use Illuminate\Support\Facades\Route;


Route::get('/', function () {
    return view('auth.login');
});

// Route::controller(BlogController::class)->group(function () {
//     Route::get('/', 'home_page')->name('home_page');
//     Route::get('/blog/{slug}', 'blog_details_page')->name('blog_details.page');
//     Route::get('/blog/category/{category_slug}', 'blog_page')->name('blog_category.page');
// });

// Route::view('/admin/dashboard', 'admin.dashboard')->name('dashboard');

Route::prefix('admin')->group(function () {
    Route::controller(AuthController::class)->group(function () {
        Route::get('/login', 'adminlogin')->name('login');
        Route::post('/login', 'login')->name('login');
        Route::get('/logout', 'logout')->name('logout');
        Route::post('/logout', 'logout');
    });

    // =========== Dashboard ==========

    Route::view('/dashboard', 'admin.dashboard')->name('dashboard');

    // =========== Slider ==========

    Route::controller(SliderController::class)->group(function () {
        Route::post('/slider/statusUpdate', 'statusUpdate');
        Route::get('/slider/delete/{id}', 'delete')->name('slider.delete');
    });
    Route::resource('slider', SliderController::class);

    // =========== Testimonial ==========

    Route::controller(TestimonialController::class)->group(function () {
        Route::get('/testimonial/delete/{id}', 'delete')->name('testimonial.delete');
    });
    Route::resource('testimonial', TestimonialController::class);

    // =========== Post Category ==========

    Route::controller(PostCategoryController::class)->group(function () {
        Route::get('/post-category/delete/{id}', 'delete')->name('post-category.delete');
    });
    Route::resource('post-category', PostCategoryController::class);

    // =========== Post ==========

    Route::controller(PostController::class)->group(function () {
        Route::get('/post/delete/{id}', 'delete')->name('post.delete');
    });

    Route::resource('post', PostController::class);

    // =========== Page ==========

    Route::controller(PageController::class)->group(function () {
        Route::get('/page/delete/{id}', 'delete')->name('page.delete');
    });

    Route::resource('page', PageController::class);
});
