@extends('admin.layouts.admin_layout')
@section('title', env('APP_NAME'))
@section('main-content')

    <style>
        .imgc {
            margin-top: 20px;
            position: relative;
            width: 100%;
            height: 170px;
            background: rgb(197, 197, 197);
        }

        .imgc img {
            width: 100%;
            height: 168px;
        }

        .imgc .btn {
            position: absolute;
            top: 8%;
            left: 98%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            background-color: red;
            color: white;
            font-size: 10px;
            border-radius: 50%;
            cursor: pointer;
            text-align: center;
        }

        .imgc .btn:hover {

            background-color: red;
            color: #fff;
            font-size: 16px;
        }

        .imgc:hover {
            cursor: pointer;
            transform: translate(-1%, -1%);
            border: 1px solid red;
        }
    </style>

    <div class="admin-container">
        @php
            $tbx['tb'] = true;
            $tbx['back-btn'] = route('post.index');
            $tbx['title'] = 'Edit Post';
            $route_name = 'post';
            $image_dir = 'assets/img/post/';
        @endphp
        @include('admin.includes.title-bar')

        <form class="row" action="{{ route($route_name . '.store') }}" enctype="multipart/form-data" id="myForm"
            method="POST">
            @csrf
            <input type="hidden" value="UPDATE" name="action">
            <input type="hidden" value="{{ $data->id }}" name="id">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-12">
                        <label for="" class="form-label">Title</label>
                        <input type="text" class="form-control" name="title" value="{{ $data->title }}">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Slug</label>
                        <input type="text" class="form-control" readonly value="{{ $data->slug }}">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Meta Title</label>
                        <input type="text" class="form-control" name="meta_title" value="{{ $data->meta_title }}">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Meta Description</label>
                        <textarea class="form-control" rows="2" name="meta_description">{{ $data->meta_description }}</textarea>
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Meta Keywords</label>
                        <input type="text" class="form-control" name="meta_keywords" value="{{ $data->meta_keywords }}">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Meta Author Name</label>
                        <input type="text" class="form-control" name="author_name" value="{{ $data->author_name }}">
                    </div>
                    <div class="col-12">
                        <label for="" class="form-label">Content</label>
                        <textarea class="form-control" id="html_content" name="content" hidden>{{ $data->content }}</textarea>
                    </div>

                    <div class="col-sm-4">
                        <label for="" class="form-label">Category</label>
                        @include('admin.includes.post-categories')
                    </div>
                    <div class="col-sm-4">
                        <label class="form-label">Status</label>
                        @include('admin.includes.select-status')
                    </div>
                    <div class="col-md-6">
                        {{-- @include('admin.includes.input-image') --}}
                        @php
                            $image_path = $data->image == null ? 'assets/img/post/dummy-image.png' : 'assets/img/post/' . $data->image;
                            
                        @endphp

                        <div class="imgc">
                            <img id="img1" src="{{ asset($image_path) }}" alt="img">
                            <input accept="image/*" type="file" name="file1" id="file1" hidden />
                            <button type="button" id="delete1" class="btn"> <i class="icofont-trash"></i></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                {{-- @include('admin.includes.save-button') --}}
                <button type="submit" name="submit" class="btn btn-primary fs-4 mt-4 disable_btn">
                    Update
                </button>
            </div>
        </form>
    </div>
@endsection


@section('script')
    <script>
        $(document).ready(function() {
            Laraberg.init('html_content');
            document.querySelector(
                "#myForm > div.col-md-12 > div > div:nth-child(7) > div > div > div > div.block-editor__header > div:nth-child(2) > button"
            ).click();
        });


        if ($('#img1').attr('src') == "{{ url('assets/img/post/dummy-image.png') }}") {
            $("#delete1").hide();
        }

        $("#img1").click(function() {
            $("#file1").val(null);
            $('#file1').click();
        });

        $("#file1").change(function() {

            var tmpath = URL.createObjectURL(this.files[0]);

            $('#img1').attr('src', tmpath);
            $("#delete1").show();

        });

        $("#delete1").click(function() {
            $("#delete1").hide();
            $('#img1').attr('src', "{{ url('assets/img/post/dummy-image.png') }}");
        });
    </script>
@endsection
