<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class UserAuthMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->path() == 'admin/login' && $request->session()->has('user')) {
            return redirect('/admin/dashboard');
        } else if ($request->path() == 'admin/dashboard' && !$request->session()->has('user')) {
            return redirect('/admin/login');
        }

        return $next($request);
    }
}
