<?php

namespace App\Http\Controllers;

use App\Models\Post;
use App\Models\PostCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Str;


class PostController extends Controller
{
    public $view_dir = 'admin.post.';
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data_list = Post::all();
        return view($this->view_dir . 'index', ['data_list' => $data_list]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $categories = PostCategory::all();
        return view($this->view_dir . 'create', compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $req)
    {
        if ($req->action == 'CREATE') {


            $id = Post::max('id') + 1;
            $post = new Post();
            $post->title = $req->title;
            $post->slug = Str::of($post->title)->slug('-');
            $post->content = $req->content;
            $post->meta_title = $req->meta_title;
            $post->meta_description = $req->meta_description;
            $post->meta_keywords = $req->meta_keywords;
            $post->author_name = $req->author_name;
            $post->category = $req->category;
            $post->status = $req->status;
            if ($req->file('file1')) {
                $file = $req->file('file1');
                $image = $id . "_post." . $file->getClientOriginalExtension();
                $file->move('assets/img/post', $image);
                $post->image = $image;
            }
            $status = $post->save();

            if ($status) {
                return redirect('admin/post');
            } else {
                return view($this->view_dir . '.create');
            }
        }

        if ($req->action == 'UPDATE') {
            $post = Post::find($req->id);
            $post->title = $req->title;
            $post->slug = Str::of($post->title)->slug('-');
            $post->content = $req->content;
            $post->meta_title = $req->meta_title;
            $post->meta_description = $req->meta_description;
            $post->meta_keywords = $req->meta_keywords;
            $post->author_name = $req->author_name;
            $post->category = $req->category;
            $post->status = $req->status;
            if ($req->file('file1')) {
                $file = $req->file('file1');
                $image = $file->getClientOriginalName();
                $file->move('assets/img/post', $image);
                $post->image = $image;
            }

            $status = $post->update();

            if ($status) {
                $data_list = Post::all();
                return view($this->view_dir . 'index', ['data_list' => $data_list]);
            } else {
                return view($this->view_dir . 'edit');
            }
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $data = Post::find($id);
        $categories = PostCategory::all();

        if (!empty($data)) {
            return view($this->view_dir . 'edit', compact('data', 'categories'));
        } else {
            return abort('403', 'Id Not Found');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function delete(Request $req)
    {
        $data = Post::find($req->id);
        $status = $data->delete();
        if ($status) {
            $data_list = Post::all();
            return view($this->view_dir . 'index', ['data_list' => $data_list]);
        } else {
            return view($this->view_dir . 'edit');
        }
    }
}
