<?php

namespace App\Http\Controllers;

use App\Models\PostCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PostCategoryController extends Controller
{
    public $view_dir = 'admin.post-category.';
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data_list = PostCategory::all();
        return view($this->view_dir . 'index', ['data_list' => $data_list]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view($this->view_dir . 'create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $req)
    {
        if ($req->action == 'CREATE') {
            $id = PostCategory::max('id') + 1;
            $postCategory = new PostCategory();
            $postCategory->name = $req->name;
            $postCategory->slug = Str::of($postCategory->name)->slug('-');
            $postCategory->description = $req->description;
            $postCategory->status = $req->status;
            if ($req->file('file1')) {
                $file = $req->file('file1');
                $image = $id . "_postCategory." . $file->getClientOriginalExtension();
                $file->move('assets/img/post-category', $image);
                $postCategory->image = $image;
            }
            $status = $postCategory->save();
            if ($status) {
                return redirect('admin/post-category');
            } else {
                return view($this->view_dir . '.create');
            }
        }

        if ($req->action == 'UPDATE') {
            $postCategory = PostCategory::find($req->id);
            $postCategory->name = $req->name;
            $postCategory->slug = Str::of($postCategory->name)->slug('-');
            $postCategory->description = $req->description;
            $postCategory->status = $req->status;
            if ($req->file('file1')) {
                $file = $req->file('file1');
                $image = $file->getClientOriginalName();
                $file->move('assets/img/post-category', $image);
                $postCategory->image = $image;
            }

            $status = $postCategory->update();

            if ($status) {
                $data_list = PostCategory::all();
                return view($this->view_dir . 'index', ['data_list' => $data_list]);
            } else {
                return view($this->view_dir . '.edit');
            }
        }

        if ($req->action == 'UPDATE_STATUS') {
            // $slider = Slider::Where('id', $req->sid)->first()->id;
            $status = PostCategory::Where('id', $req->id)->update([
                'status' => $req->status
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $data = PostCategory::find($id);

        if (!empty($data)) {
            return view($this->view_dir . 'edit', compact('data'));
        } else {
            return abort('403', 'Id Not Found');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function delete(Request $req)
    {
        $data = PostCategory::find($req->id);
        $status = $data->delete();
        if ($status) {
            $data_list = PostCategory::all();
            return view($this->view_dir . 'index', ['data_list' => $data_list]);
        } else {
            return view($this->view_dir . '.edit');
        }
    }
}
