<?php

namespace App\Http\Controllers;

use App\Models\Post;
use App\Models\PostCategory;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function home_page()
    {
        $categories = PostCategory::all();
        $posts = Post::all();
        return view('web.blog', ['categories' => $categories, 'posts' => $posts]);
    }

    public function blog_page(Request $req)
    {
        if (!empty($req->category_slug)) {
            $post_category = PostCategory::where('slug', $req->category_slug)->first();

            if (!empty($post_category)) {
                $posts = Post::where('status', '1')->where('category', $post_category->name)->orderBy('id', 'DESC')->get();
            }
        } else {
            $posts = Post::where('status', '1')->orderBy('id', 'DESC')->all();
        }
        $categories = PostCategory::where('status', '1')->orderBy('name', 'ASC')->get();
        // dd($posts);
        return view('web.blog', compact('posts', 'categories'));
    }

    // public function blog_details_page
}
