<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SellerController;
use App\Http\Controllers\SuperController;
use App\Http\Controllers\PdfController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [FrontendController::class, 'index'])->name('home');
Route::get('/franchisewithus', [FrontendController::class, 'franchise'])->name('franchise');
Route::post('/franchisewithus/create', [FrontendController::class, 'createFranchise'])->name('create.franchise');
Route::get('/register/success', [FrontendController::class, 'success'])->name('user.success');
Route::get('/franchise/pdf/{type}', [FrontendController::class, 'getFranchisePDF'])->name('franchise.pdf');
Route::get('/application/approved/pdf/{id}', [FrontendController::class, 'dynamicPdf'])->name('pdflink');



// Route::get('/dashboard', [SellerController::class, 'dashboard'])->name('dashboard');


Route::middleware(['auth'])->group(function(){

    Route::get('/dashboard', [SellerController::class, 'applicationStatus'])->name('dashboard');
    Route::post('/franchise/logout', [SellerController::class, 'sellerLogout'])->name('user.logout');
    Route::get('/franhise/document/upload', [SellerController::class, 'uploadDocument'])->name('document.upload');
    Route::post('/franchise/document/store', [SellerController::class, 'storeKyc'])->name('kyc.store');
    Route::get('/franchise/password/updateform', [SellerController::class, 'updatePasswordForm'])->name('update.password');
    Route::post('/franchise/password/update', [SellerController::class, 'updatePassword'])->name('password.update.franchise');

    Route::get('/franchise/basic/update', [SellerController::class, 'updateBasicForm'])->name('update.basic');
    Route::post('/franchise/basic/update', [SellerController::class, 'updateBasicDetails'])->name('update.basic');
    // PDF
    Route::get('/pdf/new', [PdfController::class, 'index'])->name('pdf');

});


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});




Route::middleware(['auth', 'role:admin'])->group(function () {
    Route::prefix('admin')->group(function () {
        Route::get('/dashboard', [AdminController::class, 'adminDashboard'])->name('admin.dashboard');
        Route::post('/logout', [AdminController::class, 'adminLogout'])->name('admin.logout');
        Route::get('/user/details/{id}', [AdminController::class, 'showUserDetails'])->name('admin.user.details');
        Route::post('/user/{id}/approve', [AdminController::class, 'approveUser'])->name('admin.user.approve');
        Route::post('/user/{id}/reject', [AdminController::class, 'rejectUser'])->name('admin.user.reject');
        Route::post('/user/{id}/pending', [AdminController::class, 'pedingUser'])->name('admin.user.pending');
        Route::get('/approved/user', [AdminController::class, 'allApprovedUser'])->name('admin.approved.users');
        Route::get('/pending/user', [AdminController::class, 'allPendingdUser'])->name('admin.pending.users');
        Route::get('/rejected/user', [AdminController::class, 'allRejectedUser'])->name('admin.rejected.users');
        Route::get('/enquiry', [AdminController::class, 'enquiryData'])->name('admin.enquiry');

        Route::get('/export', [AdminController::class, 'exportEnquiry'])->name('export.enquiry');

        Route::post('/send-login-details/{id}', [AdminController::class, 'sendLoginDetails'])->name('send.login.details');

    });
});


Route::middleware(['auth', 'role:super_admin'])->group(function () {
    Route::prefix('super_admin')->group(function () {
        Route::get('/dashboard', [SuperController::class, 'superDashboard'])->name('super.dashboard');
        Route::get('/user/details/{id}', [SuperController::class, 'showUserDetails'])->name('user.details');
        Route::get('/all/user', [SuperController::class, 'allUser'])->name('all.user');
        Route::get('/all/admin', [SuperController::class, 'allAdmin'])->name('all.admin');
        Route::get('/pending/user', [SuperController::class, 'allPendingdUser'])->name('pending.users');
        Route::post('/admin/{id}/deactivate', [SuperController::class, 'deactivateUser'])->name('admin.deactivate');
        Route::post('/admin/{id}/activate', [SuperController::class, 'activateUser'])->name('admin.activate');
        Route::post('/admin/{id}/create', [SuperController::class, 'makeAdmin'])->name('make.admin');
        Route::get('/assign/application/{id}', [SuperController::class, 'assignApplication'])->name('assign.application');
        Route::post('/process/assign/application/{id}', [SuperController::class, 'processAssignApplication'])->name('process.assign.application');

        Route::get('/delete/application/{id}', [SuperController::class, 'deleteApplication'])->name('delete.application');
        Route::post('/process/de-assign/application/{id}', [SuperController::class, 'processDeassignApplication'])->name('process.deassign.application');
        Route::get('/assigned/application/{id}', [SuperController::class, 'assignedApplication'])->name('assigned.application');

        Route::get('/approved/user', [SuperController::class, 'allApprovedUser'])->name('approved.users');
        Route::get('/pending/user', [SuperController::class, 'allPendingdUser'])->name('pending.users');
        Route::get('/rejected/user', [SuperController::class, 'allRejectedUser'])->name('rejected.users');
        
        Route::post('/user/{id}/approve', [SuperController::class, 'approveUser'])->name('sadmin.user.approve');
        Route::post('/user/{id}/reject', [SuperController::class, 'rejectUser'])->name('sadmin.user.reject');
        Route::post('/user/{id}/pending', [SuperController::class, 'pedingUser'])->name('sadmin.user.pending');


        Route::get('/enquiry', [SuperController::class, 'enquiryData'])->name('enquiry');
        Route::get('/export', [SuperController::class, 'exportEnquiry'])->name('export.enquiry');

        Route::post('/logout', [SuperController::class, 'superAdminLogout'])->name('super.logout');


    });
});



require __DIR__.'/auth.php';
