@extends('user.dashboard.layouts.master')

@section('title')
    <title>Update Basic &  Business Details</title>
@endsection

@section('content')
    <div class="app-main__outer">
        <div class="app-main__inner">
            <form action="{{route('update.basic')}}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-body">
                                <h5 class="card-title">Personal Data</h5>

                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="name">Full Name:</label>
                                        <input type="text" id="name" name="name" class="form-control" value="{{ $user->name }}" >
                                    </div>
                                    <div class="col-md-3">
                                        <label for="nationality">Nationality:</label>
                                        <input type="text" id="nationality" name="nationality" class="form-control" value="{{ $profile->nationality }}">
                                    </div>

                                    <div class="col-md-3">
                                        <label for="education">Education:</label>
                                        <input type="text" id="education" name="education" class="form-control" value="{{ $profile->education ?? 'NA' }}">
                                    </div>

                                    <div class="col-md-3">
                                        <label for="address">Address:</label>
                                        <input type="text" id="address" name="address" class="form-control" value="{{ $user->address ?? 'NA' }}">
                                    </div>

                                </div>

                               <div class="row mt-3">

                                <div class="col-md-3">
                                    <label for="city">City:</label>
                                    <input type="text" id="city" name="city" class="form-control" value="{{ $profile->city ?? 'NA' }}">
                                </div>


                                <div class="col-md-3">
                                    <label for="state">State:</label>
                                    <input type="text" id="state" name="state" class="form-control" value="{{ $profile->state ?? 'NA' }}">
                                </div>

                                <div class="col-md-3">
                                    <label for="work_no">Telephone (Work):</label>
                                    <input type="text" id="work_no" name="work_no" class="form-control" value="{{ $profile->work_no ?? 'NA' }}">
                                </div>

                                <div class="col-md-3">
                                    <label for="email">Email:</label>
                                    <input type="text" id="email" name="email" class="form-control" value="{{ $user->email ?? 'NA' }}">
                                </div>

                                <div class="col-md-3">
                                    <label for="website">Website:</label>
                                    <input type="text" id="website" name="website" class="form-control" value="{{ $user->profile->website ?? 'NA' }}">
                                </div>

                               </div>


                            </div>


                            <div class="card-body">
                                <h5 class="card-title">Address of the place where you intend to start Kerala Ayurveda Center
                                    Franchise</h5>

                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="business_city">City:</label>
                                        <input type="text" id="business_city" name="business_city" class="form-control"
                                        value="{{ $profile->business_city ?? '' }}" {{$user->hasVerified() ? 'disabled' : ''}}>
                                    </div>

                                     <div class="col-md-3">
                                        <label for="business_state">State:</label>
                                        <input type="text" id="business_state" name="business_state" class="form-control"
                                        value="{{ $profile->business_state ?? '' }}" {{$user->hasVerified() ? 'disabled' : ''}}>
                                    </div>

                                    <div class="col-md-3">
                                        <label for="pincode">Pincode:</label>
                                        <input type="text" id="pincode" name="business_pincode" class="form-control"
                                        value="{{ $profile->business_pincode ?? '' }}" {{$user->hasVerified() ? 'disabled' : ''}}>
                                    </div>

                                    <div class="col-md-3">
                                        <label for="know_about_center">How did you come to know about Kerala Ayurveda Center: :</label>
                                        <input type="text" id="know_about_center" name="know_about_center" class="form-control"
                                        value="{{ $user->know_about_cente ?? '' }}" {{$user->hasVerified() ? 'disabled' : ''}}>
                                    </div>

                                </div>

                               <div class="row mt-3">

                                <div class="col-md-3">
                                    <label for="industry_exp">Do you have any past experience in Spa/hospitality industry:</label>
                                    <select name="industry_exp" required class="form-control" id="industryExp">
                                        <option value="" {{ old('industry_exp', $profile->industry_exp) == '' ? 'selected' : '' }}>Select Value</option>
                                        <option value="YES" {{ old('industry_exp', $profile->industry_exp) == 'YES' ? 'selected' : '' }}>YES</option>
                                        <option value="NO" {{ old('industry_exp', $profile->industry_exp) == 'NO' ? 'selected' : '' }}>NO</option>
                                    </select>
                                </div>

                                <div class="col-md-3" id="experienceDescContainer" style="display: none;">
                                    <label for="experience_desc">experience_desc:</label>
                                    <input type="text" id="experience_desc" name="experience_desc" class="form-control"
                                    value="{{ $profile->experience_desc ?? '' }}" >
                                </div>

                                <div class="row mt-3">
                                    <div class="col-lg-12">
                                        @if($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <div class="col-md-3" >
                                    <label for="partnership_type">Do you intend to start it as an individual/partnership/firm(s):</label>
                                    <select name="partnership_type" required class="form-control" id="partnerInterest">
                                        <option value="" {{ old('partnership_type', $profile->partnership_type) == '' ? 'selected' : '' }}>Select Value</option>
                                        <option value="YES" {{ old('partnership_type', $profile->partnership_type) == 'YES' ? 'selected' : '' }}>YES</option>
                                        <option value="NO" {{ old('partnership_type', $profile->partnership_type) == 'NO' ? 'selected' : '' }}>NO</option>
                                    </select>
                                </div>


                                <div class="col-md-3" style="display: none" id="partnerInterestContainer">
                                    <label for="partner_dtl">If yes provide the details of Partner / firm(s):</label>
                                    <input type="text" id="partner_dtl" name="partner_dtl" class="form-control" value="{{ $profile->partner_dtl ?? '' }}">
                                </div>
                               </div>

                               <div class="row mt-3">

                                <div class="col-md-3">
                                    <label for="current_earning">Current Earning:</label>
                                    <input type="text" id="current_earning" name="current_earning" class="form-control"
                                    value="{{ $profile->current_earning ?? '' }}" {{$user->hasVerified() ? 'disabled' : ''}}>
                                </div>

                                <div class="col-md-3">
                                    <label for="current_asset_holding">Current Asset Holdings:</label>
                                    <input type="text" id="current_asset_holding" name="current_asset_holding" class="form-control"
                                    value="{{ $profile->current_asset_holding ?? '' }}" {{$user->hasVerified() ? 'disabled' : ''}}>
                                </div>

                                <div class="col-md-3">
                                    <label for="money_invest">How much money do you intend to invest in the Spa/ Resort:</label>
                                    <input type="text" id="money_invest" name="money_invest" class="form-control"
                                    value="{{ $profile->money_invest ?? '' }}" {{$user->hasVerified() ? 'disabled' : ''}}>
                                </div>

                                <div class="col-md-3">
                                    <label for="space">How much space you have for the same:</label>
                                    <input type="text" id="space" name="space" class="form-control"
                                    value="{{ $profile->space ?? '' }}" {{$user->hasVerified() ? 'disabled' : ''}}>
                                </div>

                               </div>

                               <div class="row mt-3">
                                <div class="col-md-3">
                                    <label for="property_type">Property Type:</label>
                                    <select name="prop_type" required class="form-control">
                                        <option value="{{ $profile->prop_type == '' ? 'selected' : '' }}" {{ old('prop_type', $profile->prop_type) == '' ? 'selected' : '' }}>Select Value</option>
                                        <option value="lease" {{ old('prop_type', $profile->prop_type) == 'lease' ? 'selected' : '' }}>Lease</option>
                                        <option value="owned" {{ old('prop_type', $profile->prop_type) == 'owned' ? 'selected' : '' }}>Owned</option>
                                        <option value="rent" {{ old('prop_type', $profile->prop_type) == 'rent' ? 'selected' : '' }}>Rent</option>
                                    </select>
                                </div>

                                <div class="col-md-3">
                                    <label for="franchise_type">Franchise Type:</label>
                                    <select name="franchise_type"  required class="form-control">
                                        <option value="" {{ $profile->franchise_type == '' ? 'selected' : '' }} >Select Value</option>
                                        <option value="2room" {{ $profile->franchise_type == '2room' ? 'selected' : '' }}>2 ROOM</option>
                                        <option value="4room" {{ $profile->franchise_type == '4room' ? 'selected' : '' }}>4 ROOM</option>
                                    </select>
                                </div>



                                <div class="col-md-3">
                                    <label for="photo">Photo:</label>
                                    <input type="file" id="photo" name="photo" class="form-control" accept=".jpg, .jpeg, .png" >
                                    <small class="text-muted">Accepted file types: JPG, JPEG, PNG</small>
                                </div>

                                <div class="col-md-3">
                                    <label for="signature_img">Signature:</label>
                                    <input type="file" id="signature_img" name="signature_img" class="form-control" accept=".jpg, .jpeg, .png" >
                                    <small class="text-muted">Accepted file types: JPG, JPEG, PNG</small>
                                </div>

                               </div>

                               <div class="row mt-6 mb-3 text-center">
                                <div class="col-md-12 mt-4">
                                   <button class="btn btn-outline-primary" type="submit">Update Details</button>
                                </div>
                               </div>
                            </div>
                        </div>


                    </div>

                </div>

            </form>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <script>
        $(document).ready(function () {
            // Function to show/hide fields based on dropdown selection
            function toggleFieldVisibility() {
                var partnerInterestValue = $('#partnerInterest').val();
                var industryExpValue = $('#industryExp').val();

                // Hide all containers
                $('#partnerInterestContainer').hide();
                $('#experienceDescContainer').hide();

                // Show the relevant container based on the selected dropdown
                if (partnerInterestValue === 'YES') {
                    $('#partnerInterestContainer').show();
                }

                if (industryExpValue === 'YES') {
                    $('#experienceDescContainer').show();
                }
            }

            // Initial setup
            toggleFieldVisibility();

            // Show/hide fields when dropdown selections change
            $('#partnerInterest').change(function () {
                toggleFieldVisibility();
            });

            $('#industryExp').change(function () {
                toggleFieldVisibility();
            });
        });
    </script>



@endsection
