@extends('user.dashboard.layouts.master')

@section('title')
    <title>Submit Kyc Details</title>
@endsection

@section('content')
    <div class="app-main__outer">
        <div class="app-main__inner">
            <div class="row">
                <div class="col-md-12">
                    <div class="main-card mb-3 card">
                        <div class="card-body">
                            <h5 class="card-title">Submit Kyc Details</h5>
                            <form class="" action="{{ route('kyc.store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="row mt-3">
                                    <div class="col-md-6">
                                        <label for="pancard_no" class="">Pan No*</label>
                                        <input name="pancard_no" id="pancard_no" value="{{$user->pancard_no ?? ''}}" required pattern="[A-Z]{5}[0-9]{4}[A-Z]{1}" title="Enter a valid PAN number"
                                        type="text" class="form-control" {{ $user->hasSubmittedKYC() ? 'disabled' : '' }}>
                                    </div>

                                    <div class="col-md-6">
                                        <label for="adhar_no" class="">Adhar No*</label>
                                        <input name="adhar_no" id="adhar_no" value="{{$user->adhar_no ?? ''}}" required pattern="[0-9]{12}" title="Enter a valid 12-digit Aadhar number" type="text" class="form-control"
                                        {{$user->hasSubmittedKYC() ? 'disabled' : ''}}>
                                    </div>
                                </div>
                                <button class="btn btn-primary my-4" {{ $user->hasSubmittedKYC() ? 'disabled' : '' }}>Submit Details</button>
                            </form>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
