@extends('user.dashboard.layouts.master')

@section('title')
    <title>Application Status</title>
@endsection

@section('content')
    <div class="app-main__outer">
        <div class="app-main__inner">
            <div class="row">
                <div class="col-md-12">
                    <div class="main-card mb-3 card">
                        <div class="card-body">
                            <h5 class="card-title">Application Status</h5>

                            @if ($user->kyc_verification_status === 'approved')
                                <div class="alert alert-success" role="alert">
                                    Your KYC document has been verified successfully!
                                </div>
                            @elseif ($user->kyc_verification_status === 'rejected')
                                <div class="alert alert-danger" role="alert">
                                    Your KYC document has been rejected. Please re-submit.
                                </div>
                            @else
                                <div class="alert alert-warning" role="alert">
                                    @if ($user->adhar_no && $user->pancard_no)
                                        Your KYC document (Aadhar: {{ $user->adhar_no }}, Pan Card: {{ $user->pancard_no }})
                                        is uploaded and pending for approval.
                                    @else
                                        Your KYC document is pending for submission.
                                    @endif
                                </div>
                            @endif

                            @if ($user->kyc_verification_status === 'approved' && $user->application_no)
                                <div class="alert alert-info" role="alert">
                                    Your application number: {{ $user->application_no }}
                                </div>
                            @endif

                            @if (isset($error))
                                <p class="text-danger">{{ $error }}</p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
