@extends('superAdmin.layouts.master')

@section('title')
    <title>Assign - Application</title>
@endsection

@section('content')
    <div class="app-main__inner">
        <div class="app-page-title">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="pe-7s-id icon-gradient bg-mean-fruit"></i>
                    </div>
                    <div>Assign Application</div>
                </div>
                <div class="page-title-actions">
                    <div class="d-inline-block dropdown">
                        <!-- Any additional actions or buttons can be added here -->
                    </div>
                </div>
            </div>
        </div>

        <div class="main-card mb-3 card">
            <div class="card-body">
                <h5 class="card-title">Franchise Applications</h5>
                <form method="POST" action="{{ route('process.assign.application', ['id' => $user->id]) }}">
                    @csrf
                    <input type="hidden" value="{{$user->id}}" name="admin_id"/>
                    <div class="table-responsive">
                        <table class="mb-0 table">
                            <thead>
                            <tr>
                                <th>Select</th>
                                <th>Application No</th>
                                <th>Name</th>
                                <th>City</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($franchiseApplications as $application)
                                <tr>
                                    <td>
                                        <div class="custom-checkbox custom-control">
                                            <input type="checkbox" name="user_id[]" id="user_id_{{ $application->id }}" class="custom-control-input" value="{{ $application->id }}">
                                            <label class="custom-control-label" for="user_id_{{ $application->id }}"></label>
                                        </div>
                                    </td>


                                    <td>{{ $application->application_no ?? 'NA' }}</td>
                                    <td>{{ $application->name ?? 'NA' }}</td>
                                    <td>{{ $application->profile->business_city ?? 'NA' }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">Assign Selected Applications</button>
                </form>
            </div>
        </div>
    </div>
@endsection
