<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ApplicationRejected extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject('Application Rejected - Kerala Ayurveda Franchise')
        ->line('Dear ' . $notifiable->name . ',')
        ->line('We regret to inform you that your franchise application at Kerala Ayurveda has been rejected.')
        ->line('We appreciate your interest in partnering with us. Unfortunately, your submitted KYC documents did not meet our requirements.')
        ->line('If you have any questions or concerns, please feel free to contact our support team at support@keralaayurveda.com.')
        ->line('Thank you for considering Kerala Ayurveda for your franchise opportunity.')
        ->line('Sincerely,')
        ->line('Kerala Ayurveda Team')
        ->action('Visit Kerala Ayurveda', url('/'))
        ->line('Thank you for choosing Kerala Ayurveda for your wellness journey!');
}

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
