<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use App\Models\Profile;
use Illuminate\Support\Facades\Auth;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $guarded = [];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];


    public function profile()
    {
        return $this->hasOne(Profile::class);
    }

    public function assignedApplication(){
        return $this->hasMany(AssignedApplication::class);
    }

    public function hasRole($role){

        return $this->role === $role;

    }

    public function hasSubmittedKYC()
{
    $user = Auth::user();
    // Check if both pancard_no and adhar_no are present and not empty
    return !empty($user->pancard_no) && !empty($user->adhar_no);
}


   public function hasVerified(){
       $user = Auth::user();

       return !empty($user->application_no);
   }

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];
}
