<?php

namespace App\Listeners;

use App\Events\KycDocumentVerified;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Str;

class GenerateApplicationNumber implements ShouldQueue
{
    use InteractsWithQueue;

    public function handle(KycDocumentVerified $event)
    {
        $user = $event->user;

        // Check if the user doesn't already have an application number
        if ($user->kyc__verification_status === 'approved' && !$user->application_no) {
            $randomNumber = str_pad(mt_rand(1, 9999999999), 10, '0', STR_PAD_LEFT);

            // Combine with 'APP' to create the application number
            $applicationNumber = 'APP' . $randomNumber;

            // Update the user with the generated application number
            $user->update(['application_no' => $applicationNumber]);
        }

    }
}
