<?php

namespace App\Http\Controllers;
use App\Events\KycDocumentVerified;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Notification;
use App\Notifications\ApplicationRejected;
use Illuminate\Support\Facades\Crypt;
use App\Models\AssignedApplication;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\EnquiryExport;

class SuperController extends Controller
{
    public function superDashboard(){
        $totalUsers = User::where('role', '!=', 'admin')->count();
        $activeUsers = User::where('status', 'approved')->count();
        // dd($activeUsers);
        $pendingUsers = User::where('status', 'pending')->count();
        $rejectedUsers = User::where('status', 'rejected')->count();

        //Fetch the latest applications from the users table
        $latestApplications = User::with(['profile' => function ($query) {
            $query->select('user_id', 'city');
        }])
        ->where('kyc__verification_status', 'pending')
        ->where('role', 'franchise')
        ->orderBy('created_at', 'desc')
        ->take(5)
        ->get(['id', 'name', 'status']);

        return view('superAdmin.pages.dashboard', compact('totalUsers', 'activeUsers', 'pendingUsers', 'rejectedUsers', 'latestApplications'));
    }


    public function showUserDetails($id)
    {
        $user = User::with('profile')->find($id);
        $encryptedPassword = $user->cred;
        $password = Crypt::decrypt($encryptedPassword);

        // return $password;

    if (!$user) {
        return abort(404);
    }
        return view('superAdmin.pages.user_datails', compact('user', 'password'));
    }


    public function allAdmin(){
        $adminUser = User::where('role', '=', 'admin')
        ->where('status', '!=', 'rejected')
        ->get();
        // return $adminUser;
        return view('superAdmin.pages.all_admin', compact('adminUser'));
    }

    public function deactivateUser($id){

        $user = User::findOrFail($id);

        $user->update([
            'status' => 'pending'
        ]);

       return redirect()->back()->with('message', 'Admin Status Deactivated');
    }

    public function activateUser($id){

        $user = User::findOrFail($id);

        $user->update([
            'role' => 'admin',
            'status' => 'approved'
        ]);

       return redirect()->back()->with('message', 'Admin Status Activated');
    }

    public function allUser(){
        $user = User::where('role', '!=', 'super_admin')
        ->get();
        return view('superAdmin.pages.user', compact('user'));
    }



    public function pedingUser($id){
        $user = User::findOrFail($id);

        $user->update([
            'status' => 'pending'
        ]);

        return redirect()->route('super.dashboard')->with('message', 'Franchise Status has been Pending');

    }

    public function assignApplication($id){
        $user = User::findOrFail($id);

        $franchiseApplications = User::with('profile')
        ->where('adminAssignStatus', '=', 0)
        ->where('role', '=', 'franchise')
        ->get();
        return view('superAdmin.pages.assign_user', compact('franchiseApplications', 'user'));
    }

    public function processAssignApplication(Request $request, $id){

        $request->validate([
            'admin_id' => 'required|exists:users,id',
        ]);

    $adminId = $request->admin_id;
    $userIds = $request->user_id;

    foreach ($userIds as $userId) {
        AssignedApplication::updateOrCreate(
            ['user_id' => $userId],
            ['admin_id' => $adminId, 'status' => 1]
        );

        // Update adminAssignStatus for each user in the loop
        User::where('id', $userId)->update([
            'adminAssignStatus' => '1'
        ]);
    }


    return redirect()->route('all.admin', ['id' => $id])
        ->with('message', 'Application assigned successfully');
}

public function deleteApplication($id){
    $user = User::findOrFail($id);

    $franchiseApplications = User::whereHas('assignedApplication', function ($query) {
        $query->where('status', '=', 1);
    })->get();


    return view('superAdmin.pages.delete_application', compact('franchiseApplications', 'user'));
}

public function processDeassignApplication(Request $request, $id){

    $request->validate([
        'admin_id' => 'required|exists:users,id',
    ]);

$adminId = $request->admin_id;
$userIds = $request->user_id;

foreach ($userIds as $userId) {
    AssignedApplication::updateOrCreate(
        ['user_id' => $userId],
        ['admin_id' => $adminId, 'status' => 0]
    );

    // Update adminAssignStatus for each user in the loop
    User::where('id', $userId)->update([
        'adminAssignStatus' => 0
    ]);
}


return redirect()->route('all.admin', ['id' => $id])
    ->with('message', 'Application De-assigned successfully');
}



public function allApprovedUser(){
    $approvedUser = User::where('status', 'approved')
    ->where('role', '!=', 'admin')->where('role', '!=', 'super_admin')
    ->get();
    return view('superAdmin.pages.approved_users', compact('approvedUser'));
}


public function allPendingdUser(){
    $pendingUser = User::where('kyc__verification_status', 'pending')
     ->where('status', 'pending')
     ->where('role', '!=', 'admin')
    ->get();
    return view('superAdmin.pages.pending_users', compact('pendingUser'));
}

public function allRejectedUser(){
    $rejectedUser = User::where('status', 'rejected')
     ->where('role', '!=', 'admin')
    ->get();
    // dd($rejectedUser);
    return view('superAdmin.pages.rejected_user', compact('rejectedUser'));
}

public function enquiryData(){
    $enquiry = User::where('role', '!=', 'admin')->get();
    return view('superAdmin.pages.enquiry', compact('enquiry'));
}

public function exportEnquiry(){
    return Excel::download(new EnquiryExport, 'enquiry.xlsx');
}




public function approveUser($id) {

    // Find the user by ID
    $user = User::findOrFail($id);

    // Check if the user has a kyc_document
    if ($user->pancard_no && $user->adhar_no) {
        // Update kyc_verification_status to 'approved' and Status 'approved
        DB::transaction(function () use ($user) {
            $user->update(
                [
                    'kyc__verification_status' => 'approved',
                    'status' => 'approved'
                ]);

            // Dispatch the event to generate application number
            event(new KycDocumentVerified($user));
        });

        return redirect()->route('super.dashboard')->with('message', 'User approved successfully!');
    } else {
        // If the user doesn't have a kyc_document, handle accordingly
        return redirect()->back()->with('error', 'User cannot be approved without pan card & adhar card no.');
    }
}



public function rejectUser($id) {
    $user = User::findOrFail($id);
    // dd($user);

    // Notification::send($user, new ApplicationRejected);

    $user->update([
        'adhar_no' => null,
        'pancard_no' => null,
        'status' => 'rejected'
    ]);

    return redirect()->route('super.dashboard')->with('message', 'User rejected successfully!');
}

    public function superAdminLogout(){
        Auth::logout();
        return redirect('/')->with('message', 'Super admin has been Logged out');
    }
    

}
