<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Profile;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Mail\WelcomeMail;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Crypt;
use Barryvdh\DomPDF\Facade\Pdf;

class FrontendController extends Controller
{
    public function index(){
        return view('user.pages.home');
    }

    public function franchise() {
        return view('user.pages.franchise');
    }

    public function createFranchise(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string',
            'whatsapp_no' => 'required|numeric|digits:10',
            'email' => 'required|email',
        ]);

        // Generate a random password
        $password = Str::random(10);

        // Add password to the validated data
        $validatedData['password'] = Hash::make($password);
        $decrypt = $validatedData['cred'] =Crypt::encrypt($password);

        // Create user
        $user = User::create($validatedData);

        $profileData = [
            'user_id' => $user->id,
            'city' => $request->input('city'),
            'franchise_type' => $request->input('franchise_type'),
        ];

        // Define PDF links based on franchise types
        $pdfLinks = [
            '2room' => URL::to('/pdf/2room.pdf'),
            '4room' => URL::to('/pdf/4room.pdf'),
        ];

        // Set the PDF link in the profile data
        $profileData['pdf_link'] = $pdfLinks[$request->input('franchise_type')];

        $profile = Profile::create($profileData);

        $password = Crypt::decrypt($decrypt);

        // Send the welcome email with login credentials
        Mail::to($user->email)->send(new WelcomeMail($user, $password));

        // dd($password);

        return redirect()->route('user.success')->with('message', 'Account Created Successfully');
    }



    public function success(){
        return view('user.pages.success');
    }


    public function getFranchisePDF(Request $request, $type)
{
    $request->validate([
        'franchise_type' => 'required|in:2room,4room',
    ]);

    $franchiseType = $request->input('franchise_type');

    $route = route('franchise.pdf', ['type' => $franchiseType]);

    return view('pdf')->with('pdfRoute', $route);
}

 public function dynamicPdf($id){
    $user=User::with('profile')->find($id)->toArray();

     $pdf = App::make('dompdf.wrapper');
     $templateName = ($user['profile']['franchise_type'] == '2room') ? 'pdf.2room_template' : 'pdf.4room_template';
     $pdf = Pdf::loadView($templateName, ['user'=> $user]);

     return $pdf->stream();
 }

}
