<?php $__env->startSection('title'); ?>
    <title>Update Basic &  Business Details</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-main__outer">
        <div class="app-main__inner">
            <form action="<?php echo e(route('update.basic')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-body">
                                <h5 class="card-title">Personal Data</h5>

                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="name">Full Name:</label>
                                        <input type="text" id="name" name="name" class="form-control" value="<?php echo e($user->name); ?>" >
                                    </div>
                                    <div class="col-md-3">
                                        <label for="nationality">Nationality:</label>
                                        <input type="text" id="nationality" name="nationality" class="form-control" value="<?php echo e($profile->nationality); ?>">
                                    </div>

                                    <div class="col-md-3">
                                        <label for="education">Education:</label>
                                        <input type="text" id="education" name="education" class="form-control" value="<?php echo e($profile->education ?? 'NA'); ?>">
                                    </div>

                                    <div class="col-md-3">
                                        <label for="address">Address:</label>
                                        <input type="text" id="address" name="address" class="form-control" value="<?php echo e($user->address ?? 'NA'); ?>">
                                    </div>

                                </div>

                               <div class="row mt-3">

                                <div class="col-md-3">
                                    <label for="city">City:</label>
                                    <input type="text" id="city" name="city" class="form-control" value="<?php echo e($profile->city ?? 'NA'); ?>">
                                </div>


                                <div class="col-md-3">
                                    <label for="state">State:</label>
                                    <input type="text" id="state" name="state" class="form-control" value="<?php echo e($profile->state ?? 'NA'); ?>">
                                </div>

                                <div class="col-md-3">
                                    <label for="work_no">Telephone (Work):</label>
                                    <input type="text" id="work_no" name="work_no" class="form-control" value="<?php echo e($profile->work_no ?? 'NA'); ?>">
                                </div>

                                <div class="col-md-3">
                                    <label for="email">Email:</label>
                                    <input type="text" id="email" name="email" class="form-control" value="<?php echo e($user->email ?? 'NA'); ?>">
                                </div>

                                <div class="col-md-3">
                                    <label for="website">Website:</label>
                                    <input type="text" id="website" name="website" class="form-control" value="<?php echo e($user->website ?? 'NA'); ?>">
                                </div>

                               </div>


                            </div>


                            <div class="card-body">
                                <h5 class="card-title">Address of the place where you intend to start Kerala Ayurveda Center
                                    Franchise</h5>

                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="business_city">City:</label>
                                        <input type="text" id="business_city" name="business_city" class="form-control" value="<?php echo e($profile->business_city ?? 'NA'); ?>" >
                                    </div>

                                     <div class="col-md-3">
                                        <label for="business_state">State:</label>
                                        <input type="text" id="business_state" name="business_state" class="form-control" value="<?php echo e($profile->business_state ?? 'NA'); ?>" >
                                    </div>

                                    <div class="col-md-3">
                                        <label for="pincode">Pincode:</label>
                                        <input type="text" id="pincode" name="business_pincode" class="form-control" value="<?php echo e($profile->business_pincode ?? 'NA'); ?>">
                                    </div>

                                    <div class="col-md-3">
                                        <label for="know_about_center">How did you come to know about Kerala Ayurveda Center: :</label>
                                        <input type="text" id="know_about_center" name="know_about_center" class="form-control" value="<?php echo e($user->know_about_cente ?? 'NA'); ?>">
                                    </div>

                                </div>

                               <div class="row mt-3">

                                <div class="col-md-3">
                                    <label for="industry_exp">Do you have any past experience in Spa/hospitality industry:</label>
                                    <select name="industry_exp" required class="form-control" id="industryExp">
                                        <option value="" <?php echo e(old('industry_exp', $profile->industry_exp) == '' ? 'selected' : ''); ?>>Select Value</option>
                                        <option value="YES" <?php echo e(old('industry_exp', $profile->industry_exp) == 'YES' ? 'selected' : ''); ?>>YES</option>
                                        <option value="NO" <?php echo e(old('industry_exp', $profile->industry_exp) == 'NO' ? 'selected' : ''); ?>>NO</option>
                                    </select>
                                </div>

                                <div class="col-md-3" id="experienceDescContainer" style="display: none;">
                                    <label for="experience_desc">experience_desc:</label>
                                    <input type="text" id="experience_desc" name="experience_desc" class="form-control" value="<?php echo e($profile->experience_desc ?? 'NA'); ?>">
                                </div>

                                <div class="row mt-3">
                                    <div class="col-lg-12">
                                        <?php if($errors->any()): ?>
                                            <div class="alert alert-danger">
                                                <ul>
                                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e($error); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="col-md-3" >
                                    <label for="partnership_type">Do you intend to start it as an individual/partnership/firm(s):</label>
                                    <select name="partnership_type" required class="form-control" id="partnerInterest">
                                        <option value="" <?php echo e(old('partnership_type', $profile->partnership_type) == '' ? 'selected' : ''); ?>>Select Value</option>
                                        <option value="YES" <?php echo e(old('partnership_type', $profile->partnership_type) == 'YES' ? 'selected' : ''); ?>>YES</option>
                                        <option value="NO" <?php echo e(old('partnership_type', $profile->partnership_type) == 'NO' ? 'selected' : ''); ?>>NO</option>
                                    </select>
                                </div>


                                <div class="col-md-3" style="display: none" id="partnerInterestContainer">
                                    <label for="partner_dtl">If yes provide the details of Partner / firm(s):</label>
                                    <input type="text" id="partner_dtl" name="partner_dtl" class="form-control" value="<?php echo e($profile->partner_dtl ?? 'NA'); ?>">
                                </div>
                               </div>

                               <div class="row mt-3">

                                <div class="col-md-3">
                                    <label for="current_earning">Current Earning:</label>
                                    <input type="text" id="current_earning" name="current_earning" class="form-control" value="<?php echo e($profile->current_earning ?? 'NA'); ?>">
                                </div>

                                <div class="col-md-3">
                                    <label for="current_asset_holding">Current Asset Holdings:</label>
                                    <input type="text" id="current_asset_holding" name="current_asset_holding" class="form-control" value="<?php echo e($profile->current_asset_holding ?? 'NA'); ?>">
                                </div>

                                <div class="col-md-3">
                                    <label for="money_invest">How much money do you intend to invest in the Spa/ Resort:</label>
                                    <input type="text" id="money_invest" name="money_invest" class="form-control" value="<?php echo e($profile->money_invest ?? 'NA'); ?>">
                                </div>

                                <div class="col-md-3">
                                    <label for="space">How much space you have for the same:</label>
                                    <input type="text" id="space" name="space" class="form-control" value="<?php echo e($profile->space ?? 'NA'); ?>">
                                </div>

                               </div>

                               <div class="row mt-3">
                                <div class="col-md-3">
                                    <label for="property_type">Property Type:</label>
                                    <select name="prop_type" required class="form-control">
                                        <option value="<?php echo e($profile->prop_type == '' ? 'selected' : ''); ?>" <?php echo e(old('prop_type', $profile->prop_type) == '' ? 'selected' : ''); ?>>Select Value</option>
                                        <option value="lease" <?php echo e(old('prop_type', $profile->prop_type) == 'lease' ? 'selected' : ''); ?>>Lease</option>
                                        <option value="owned" <?php echo e(old('prop_type', $profile->prop_type) == 'owned' ? 'selected' : ''); ?>>Owned</option>
                                        <option value="rent" <?php echo e(old('prop_type', $profile->prop_type) == 'rent' ? 'selected' : ''); ?>>Rent</option>
                                    </select>
                                </div>

                                <div class="col-md-3">
                                    <label for="franchise_type">Franchise Type:</label>
                                    <select name="franchise_type" required class="form-control">
                                        <option value="" <?php echo e($profile->franchise_type == '' ? 'selected' : ''); ?>>Select Value</option>
                                        <option value="2room" <?php echo e($profile->franchise_type == '2room' ? 'selected' : ''); ?>>2 ROOM</option>
                                        <option value="4room" <?php echo e($profile->franchise_type == '4room' ? 'selected' : ''); ?>>4 ROOM</option>
                                    </select>
                                </div>



                                <div class="col-md-3">
                                    <label for="photo">Photo:</label>
                                    <input type="file" id="photo" name="photo" class="form-control" accept=".jpg, .jpeg, .png" >
                                    <small class="text-muted">Accepted file types: JPG, JPEG, PNG</small>
                                </div>

                                <div class="col-md-3">
                                    <label for="signature_img">Signature:</label>
                                    <input type="file" id="signature_img" name="signature_img" class="form-control" accept=".jpg, .jpeg, .png" >
                                    <small class="text-muted">Accepted file types: JPG, JPEG, PNG</small>
                                </div>

                               </div>

                               <div class="row mt-6 mb-3 text-center">
                                <div class="col-md-12 mt-4">
                                   <button class="btn btn-outline-primary" type="submit">Update Details</button>
                                </div>
                               </div>
                            </div>
                        </div>


                    </div>

                </div>

            </form>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <script>
        $(document).ready(function () {
            // Function to show/hide fields based on dropdown selection
            function toggleFieldVisibility() {
                var partnerInterestValue = $('#partnerInterest').val();
                var industryExpValue = $('#industryExp').val();

                // Hide all containers
                $('#partnerInterestContainer').hide();
                $('#experienceDescContainer').hide();

                // Show the relevant container based on the selected dropdown
                if (partnerInterestValue === 'YES') {
                    $('#partnerInterestContainer').show();
                }

                if (industryExpValue === 'YES') {
                    $('#experienceDescContainer').show();
                }
            }

            // Initial setup
            toggleFieldVisibility();

            // Show/hide fields when dropdown selections change
            $('#partnerInterest').change(function () {
                toggleFieldVisibility();
            });

            $('#industryExp').change(function () {
                toggleFieldVisibility();
            });
        });
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techiemithlesh/franchise/resources/views/user/dashboard/pages/update_basic_details.blade.php ENDPATH**/ ?>