<?php $__env->startSection('title'); ?>
    <title>Assign - Application</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-main__inner">
        <div class="app-page-title">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="pe-7s-id icon-gradient bg-mean-fruit"></i>
                    </div>
                    <div>Assign Application</div>
                </div>
                <div class="page-title-actions">
                    <div class="d-inline-block dropdown">
                        <!-- Any additional actions or buttons can be added here -->
                    </div>
                </div>
            </div>
        </div>

        <div class="main-card mb-3 card">
            <div class="card-body">
                <h5 class="card-title">Franchise Applications</h5>
                <form method="POST" action="<?php echo e(route('process.assign.application', ['id' => $user->id])); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" value="<?php echo e($user->id); ?>" name="admin_id"/>
                    <div class="table-responsive">
                        <table class="mb-0 table">
                            <thead>
                            <tr>
                                <th>Select</th>
                                <th>Application No</th>
                                <th>Name</th>
                                <th>City</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $franchiseApplications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="custom-checkbox custom-control">
                                            <input type="checkbox" name="user_id[]" id="user_id_<?php echo e($application->id); ?>" class="custom-control-input" value="<?php echo e($application->id); ?>">
                                            <label class="custom-control-label" for="user_id_<?php echo e($application->id); ?>"></label>
                                        </div>
                                    </td>


                                    <td><?php echo e($application->application_no ?? 'NA'); ?></td>
                                    <td><?php echo e($application->name ?? 'NA'); ?></td>
                                    <td><?php echo e($application->profile->business_city ?? 'NA'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">Assign Selected Applications</button>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('superAdmin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/keralaayurvedace/public_html/franchise/resources/views/superAdmin/pages/assign_user.blade.php ENDPATH**/ ?>