<?php $__env->startSection('title'); ?>
    <title><?php echo e($user->name); ?> - Deatils</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-main__inner">
        <div class="app-page-title">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="pe-7s-id icon-gradient bg-mean-fruit"></i>
                    </div>
                    <div>Franchise Details</div>
                </div>
                <div class="page-title-actions">
                    <div class="d-inline-block dropdown">
                        <!-- Any additional actions or buttons can be added here -->
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="main-card mb-3 card">
                    <div class="card-body">
                        <h5 class="card-title">Personal Data</h5>

                        <div class="row">
                            <div class="col-md-3">
                                <label for="name">Full Name:</label>
                                <input type="text" id="name" name="name" class="form-control"
                                    value="<?php echo e($user->name); ?>">
                            </div>
                            <div class="col-md-3">
                                <label for="nationality">Nationality:</label>
                                <input type="text" id="nationality" name="nationality" class="form-control"
                                    value="<?php echo e($user->profile->nationality ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="education">Education:</label>
                                <input type="text" id="education" name="education" class="form-control"
                                    value="<?php echo e($user->profile->education ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="address">Address:</label>
                                <input type="text" id="address" name="address" class="form-control"
                                    value="<?php echo e($user->profile->address ?? 'NA'); ?>">
                            </div>

                        </div>

                        <div class="row mt-3">

                            <div class="col-md-3">
                                <label for="city">City:</label>
                                <input type="text" id="city" name="city" class="form-control"
                                    value="<?php echo e($user->profile->city ?? 'NA'); ?>">
                            </div>


                            <div class="col-md-3">
                                <label for="state">State:</label>
                                <input type="text" id="state" name="state" class="form-control"
                                    value="<?php echo e($user->profile->state ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="work_no">Telephone (Work):</label>
                                <input type="text" id="work_no" name="work_no" class="form-control"
                                    value="<?php echo e($user->profile->work_no ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="email">Email:</label>
                                <input type="text" id="email" name="email" class="form-control"
                                    value="<?php echo e($user->email ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="website">Website:</label>
                                <input type="text" id="website" name="website" class="form-control"
                                    value="<?php echo e($user->profile->website ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="website">Mobile No:</label>
                                <input type="text" id="mobile_no" name="mobile_no" class="form-control"
                                    value="<?php echo e($user->mobile_no ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="website">Whatsapp No:</label>
                                <input type="text" id="whatsapp_no" name="whatsapp_no" class="form-control"
                                    value="<?php echo e($user->whatsapp_no ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="website">Application No:</label>
                                <input type="text" id="application_no" name="application_no" class="form-control"
                                    value="<?php echo e($user->application_no ?? 'NA'); ?>" readonly>
                            </div>

                        </div>

                        <div class="row mt-3">
                            <div class="col-md-3">
                                <label for="website">Adhar No:</label>
                                <input type="text" id="adhar_no" name="adhar_no" class="form-control"
                                    value="<?php echo e($user->adhar_no ?? 'NA'); ?>" readonly>
                            </div>

                            <div class="col-md-3">
                                <label for="website">Pan Card No:</label>
                                <input type="text" id="pancard_no" name="pancard_no" class="form-control"
                                    value="<?php echo e($user->pancard_no ?? 'NA'); ?>" readonly>
                            </div>

                        </div>


                    </div>

                    <div class="card-body">
                        <h5 class="card-title">Address of the place where you intend to start Kerala Ayurveda Center
                            Franchise</h5>

                        <div class="row">
                            <div class="col-md-3">
                                <label for="business_city">City:</label>
                                <input type="text" id="business_city" name="business_city" class="form-control"
                                    value="<?php echo e($user->profile->business_city ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="business_state">State:</label>
                                <input type="text" id="business_state" name="business_state" class="form-control"
                                    value="<?php echo e($user->profile->business_state ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="pincode">Pincode:</label>
                                <input type="text" id="pincode" name="business_pincode" class="form-control"
                                    value="<?php echo e($user->profile->business_pincode ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="know_about_center">How did you come to know about Kerala Ayurveda Center:
                                    :</label>
                                <input type="text" id="know_about_center" name="know_about_center"
                                    class="form-control" value="<?php echo e($user->profile->know_about_cente ?? 'NA'); ?>">
                            </div>

                        </div>

                        <div class="row mt-3">

                            <div class="col-md-3">
                                <label for="industry_exp">Do you have any past experience in Spa/hospitality
                                    industry:</label>
                                <input type="text" id="know_about_center" name="know_about_center"
                                    class="form-control" value="<?php echo e($user->profile->industry_exp ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3" id="experienceDescContainer">
                                <label for="experience_desc">experience_desc:</label>
                                <input type="text" id="experience_desc" name="experience_desc" class="form-control"
                                    value="<?php echo e($user->profile->experience_desc ?? 'NA'); ?>">
                            </div>


                            <div class="col-md-3">
                                <label for="partnership_type">Do you intend to start it as an
                                    individual/partnership/firm(s):</label>
                                <input type="text" class="form-control"
                                    value="<?php echo e($user->profile->partnership_type ?? 'NA'); ?>">

                            </div>


                            <div class="col-md-3" id="partnerInterestContainer">
                                <label for="partner_dtl">If yes provide the details of Partner / firm(s):</label>
                                <input type="text" class="form-control"
                                    value="<?php echo e($user->profile->partner_dtl ?? 'NA'); ?>">
                            </div>
                        </div>

                        <div class="row mt-3">

                            <div class="col-md-3">
                                <label for="current_earning">Current Earning:</label>
                                <input type="text" name="current_earning" class="form-control"
                                    value="<?php echo e($user->profile->current_earning ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="current_asset_holding">Current Asset Holdings:</label>
                                <input type="text" name="current_asset_holding" class="form-control"
                                    value="<?php echo e($user->profile->current_asset_holding ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="money_invest">How much money do you intend to invest in the Spa/
                                    Resort:</label>
                                <input type="text" class="form-control"
                                    value="<?php echo e($user->profile->money_invest ?? 'NA'); ?>">
                            </div>

                            <div class="col-md-3">
                                <label for="space">How much space you have for the same:</label>
                                <input type="text" class="form-control" value="<?php echo e($user->profile->space ?? 'NA'); ?>">
                            </div>

                        </div>

                        <div class="row mt-3">
                            <div class="col-md-3">
                                <label for="property_type">Property Type:</label> <br />
                                <input type="text" value="<?php echo e($user->profile->prop_type ?? 'NA'); ?>" />
                            </div>

                            <div class="col-md-3">
                                <label for="franchise_type">Franchise Type:</label> <br />
                                <input type="text" value="<?php echo e($user->profile->franchise_type ?? 'NA'); ?>" />
                            </div>

                            <div class="col-md-3">
                                <label for="photo">Photo:</label>
                                <img width="300px" height="300px" src="<?php echo e(asset($user->photo ?? 'NA')); ?>"
                                    class="form-control">
                            </div>

                            <div class="col-md-3">
                                <label for="signature_img">Signature:</label>
                                <img src="<?php echo e(asset($user->profile->signature_img ?? 'NA')); ?>"
                                    class="form-control img-fluid">
                            </div>
                        </div>

                    </div>


                </div>


                
                <div class="row mt-3">
                    <div class="col-md-12">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>



                <?php if($user->application_no): ?>
                    <button class="btn btn-outline-primary"
                        onclick="sendWhatsAppMessage('<?php echo e($user->whatsapp_no); ?>', 'Thank you for your interest in Kerala Ayurveda franchise!  We have received your application and will verify it soon. For updates, visit our website: keralaayurvedacenter.com. Feel free to contact us at franchise@keralaayurvedacenter.com. You can also view your application details here: <?php echo e(route('pdflink', [$user->id])); ?>')">
                        Send Approval Details
                    </button>
                <?php else: ?>
                    <form method="POST" action="<?php echo e(route('admin.user.approve', ['id' => $user->id])); ?>"
                        style="display: inline;">
                        <?php echo csrf_field(); ?>


                        <button type="submit" class="mb-2 mr-2 btn btn-outline-success">Approve</button>


                    </form>
                <?php endif; ?>


                <form method="POST" action="<?php echo e(route('admin.user.pending', ['id' => $user->id])); ?>"
                    style="display: inline;">
                    <?php echo csrf_field(); ?>

                    <button type="submit" class="mb-2 mr-2 btn-transition btn btn-outline-info">Pending</button>
                </form>

                <form method="POST" action="<?php echo e(route('admin.user.reject', ['id' => $user->id])); ?>"
                    style="display: inline;">
                    <?php echo csrf_field(); ?>

                    <button type="submit" class="mb-2 mr-2 btn-transition btn btn-outline-danger">Reject</button>
                </form>


                <button class="btn btn-outline-primary"
                    onclick="sendWhatsAppLogin('<?php echo e($user->whatsapp_no); ?>', 'Thank you for your interest in Kerala Ayurveda franchise!\n\nYour login details:\nEmail: <?php echo e($user->email); ?>\nPassword: <?php echo e($password); ?>\nFor updates, visit our website: keralaayurvedacenter.com.')">Send
                    Login Details</button>

            </div>

        </div>
    </div>

    <script>
        function sendWhatsAppMessage(number, message) {
            var url = 'https://wa.me/' + number + '?text=' + encodeURIComponent(message);
            window.open(url);
        }

        function showKycMessage() {
            alert('Without Kyc Details franchise cannot be approved!.');
        }

        function sendWhatsAppLogin(number, message) {
            var url = 'https://wa.me/' + number + '?text=' + encodeURIComponent(message);
            window.open(url);
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/keralaayurvedace/public_html/franchise/resources/views/admin/pages/user_datails.blade.php ENDPATH**/ ?>