<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Approval Letter</title>

    <!-- Favicon -->
    <link rel="shortcut icon" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACX0lEQVQ4jaWSX0hTcRTHz/nde3+bf+7cFtVc+xcqtolFNEmkBCuklwqSIop8qNfoJaK9RCREkPUQ/Xv3NYioxKAgFYlCiGyUaRq5DXTONdnYdnd37+8XV5sMV1T0e/j9Dofv+XDO9/zgfw+W6nufnQVFzzYt5SNXcsXlAxy4VM7mnFMOzIxIcgiYeHt6stHIk5JAZUpDLPNpuHVjoKe+xhnnwO0AYF99uX2ft7t4s+v+RK0kv2eceUt1a4ClfKRPZXnnYi5OQ+19yybBHGacQdDRrj49OhK73nnb1unarzDOKADopTqxFGSLqS4BBZhJTROJSA0dzr0DGtMC/V33JAS0GZqPyQ9DipbvI0jSFQDGdbNhiWFKNDNXdcLf63LLvqSqqbNIsIkS+jU0cn6HznVCkLCKEQyfVm4EUPUCeixb3ZH0tylCsJkSqt0avzYYzy4cI1heUtZBmd3QaGvmKSU5PhJ7eVJl6us77/rpl9TnECJWyMn6BCKB+potPKOmSXDzbs1Z66KyJPPV5v4CIKAIqq4oVpM94Lb4Fh01juCD7oGdB32H7hpb+SNA5xoU9AJ7Mz+WcNa6AsAhqnHNdHXPje2yJI+th1QADMFCdp5+zycjl8cuCCKRtoko1gFA57ldF4d+joG/BRguP5l9ZGurb28Zjb7Knho8QsKJiUnGWf5wY08LFWiMcVZd0pdvYe3vj0ZeUJvJ2uaxeKdmU9MdZ54f93ssvqJ/Q6ufcV0WCU38CrAIAMWVCBEezzy0EiAUkSQFAIxlImI0PddcLdUNb6ryXQIIVxj67wcAfgDEwfIRPPS7gAAAAABJRU5ErkJggg==" type="image/x-icon">
    <link rel="icon" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACX0lEQVQ4jaWSX0hTcRTHz/nde3+bf+7cFtVc+xcqtolFNEmkBCuklwqSIop8qNfoJaK9RCREkPUQ/Xv3NYioxKAgFYlCiGyUaRq5DXTONdnYdnd37+8XV5sMV1T0e/j9Dofv+XDO9/zgfw+W6nufnQVFzzYt5SNXcsXlAxy4VM7mnFMOzIxIcgiYeHt6stHIk5JAZUpDLPNpuHVjoKe+xhnnwO0AYF99uX2ft7t4s+v+RK0kv2eceUt1a4ClfKRPZXnnYi5OQ+19yybBHGacQdDRrj49OhK73nnb1unarzDOKADopTqxFGSLqS4BBZhJTROJSA0dzr0DGtMC/V33JAS0GZqPyQ9DipbvI0jSFQDGdbNhiWFKNDNXdcLf63LLvqSqqbNIsIkS+jU0cn6HznVCkLCKEQyfVm4EUPUCeixb3ZH0tylCsJkSqt0avzYYzy4cI1heUtZBmd3QaGvmKSU5PhJ7eVJl6us77/rpl9TnECJWyMn6BCKB+potPKOmSXDzbs1Z66KyJPPV5v4CIKAIqq4oVpM94Lb4Fh01juCD7oGdB32H7hpb+SNA5xoU9AJ7Mz+WcNa6AsAhqnHNdHXPje2yJI+th1QADMFCdp5+zycjl8cuCCKRtoko1gFA57ldF4d+joG/BRguP5l9ZGurb28Zjb7Knho8QsKJiUnGWf5wY08LFWiMcVZd0pdvYe3vj0ZeUJvJ2uaxeKdmU9MdZ54f93ssvqJ/Q6ufcV0WCU38CrAIAMWVCBEezzy0EiAUkSQFAIxlImI0PddcLdUNb6ryXQIIVxj67wcAfgDEwfIRPPS7gAAAAABJRU5ErkJggg==" type="image/x-icon">


</head>

<body>

    <div class="container" style="margin: 2rem;">
        <div class="logo" style="text-align: center;">
            <a href="https://keralaayurvedacenter.com/franchise/">
                <img src="data:image/png;base64,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" />
            </a>
        </div>
        <div class="content">
            <div class="dynamic_content_container">
                <h3 style="text-align: center; font-size: 24px">Approval Letter</h3>
                <div class="user_information">
                    <p style="font-weight: 500">Name: <span class="margin-left: 40px; "><?php echo e($user['name'] ?? ""); ?></span> </p>

                    <p style="font-weight: 500">Address: <span class="margin-left: 40px;"><?php echo e($user['address'] ?? ""); ?></span> </p>

                    <p style="font-weight: 500">Mobile No: <span class="margin-left: 40px;"><?php echo e($user['mobile_no'] ?? ""); ?></span> </p>

                    <p style="font-weight: 500">Email: <span class="margin-left: 40px;"><?php echo e($user['email'] ?? ""); ?></span> </p>
                </div>

                <h4>Your franchise application for 4 Room has been approved and Application no: <?php echo e($user['application_no'] ?? 'NA'); ?></h4>

                <div class="payment_information">
                    <p style="display: inline-block; margin: 0;">Processing fee: 5000</p> <br/>
                    <p style="display: inline-block; margin-left: 0px;">UPI ID: <span>nexgen2099@paytm</span></p>
                </div>

                <h2 class="text-center my-3 fw-bolder">FAQ – 2 Room Treatment Center</h2>
                <div class="row">
                    <h4>We have great pleasure to introduce ourself as the pioneers in promoting Ayurveda in
                        India. We have Ayurvedic Treatment Center in major cities in India, Franchise &
                        Associates Centres in PAN India
                    </h4>

                    <h5>
                        As you may know that Ayurveda is India’s ancient science of life, health, longevity and is
                        becoming increasingly recognized the world over as one of the most complete and
                        effective system of herbal medicine and natural health care. With a legacy of more than
                        5000 years of healing, the science is completely based on nature and its relationship with
                        humans. Ayurvedic philosophy works on the principal of balance of mind, body and soul
                        that result in perfect health.
                    </h5>

                    <h3>A Few FAQs about Kerala Ayurveda Center Franchise:</h3>

                    <ol>
                        <h4>1) What is the minimumarea /space required for this project?</h4>
                        <p>The minimum space requirement for a two room spa ranges between 1400 sq.ft.
                            Thiswould internal be portioned to the following: </p>
                            <ul class="list-auto">
                                <li>Reception</li>
                                <li>Consultation room</li>
                                <li>2 Treatment rooms</li>
                                <li>Shower Area</li>
                                <li>Product display/ Product Storage space</li>
                                <li>Back end- Staff space.</li>
                            </ul>
                    </ol>

                    <ol>
                        <h4>2) Which are the main features of Spa that would attract people?</h4>
                        <p>The spa can offer wellness therapies in the principals of Ayurveda. Ayurvedic therapies
                            are a hitacross India and craze around world. The main attractions could be as under.</p>
                        <ul class="list-disc">
                            <li> Preventive Healthcare (Wellness Therapies) ( Center Without Doctor )
                                <ul class="list-sign">
                                    <li>Abhyangam (Specialized Kerala Ayurveda Center Massage)
                                    </li>
                                    <li>Siro Dhara ( Pouring of oil on the forehead)</li>
                                    <li>Elakizhi (Leaf bundle massage)</li>
                                    <li>Navarakizhi( Rice Pudding Massage)</li>
                                    <li>Netra Dhara and Netra Tarpanam (Eye Care modalities)</li>
                                    <li>Lepanam ( Body wrapping)</li>
                                    <li>Thalapothichil ( Hair and scalp treatment)</li>
                                    <li>Udwarthanam ( Powder Massage)</li>
                                    <li>Head Massage</li>
                                    <li>Facial and Face Pack</li>
                                    <li>Beauty care package of Kerala Ayurveda Center</li>
                                    <li>Milk bath</li>
                                    <li>Body Pack</li>
                                    <li>Kerala Ayurveda Center’s Special Royal Makeover with or without head pack.</li>
                                </ul>
                            </li>

                            <li>Curative Healthcare (Therapeutic Programs) ( Center with Doctor)
                                <ul class="list-sign">
                                    <li>All the wellness therapies as discussed above.</li>
                                    <li>Pizhichil ( Oil bath)</li>
                                    <li>Kadhikizhi ( Special Massage)</li>
                                    <li>Kati Vasthi ( Special low back therapy)</li>
                                    <li>Pichu</li>
                                    <li>Siro Vasti</li>
                                    <li>Uro Vasti</li>
                                    <li>Panchakarma Therapies
                                        <ul class="">
                                            <li>Pre Treatment Process
                                                <ul class="list-sign">
                                                    <li>Snehanam (Oleation Therapy)</li>
                                                    <li>Swedanam ( Sudation Therapy)</li>
                                                </ul>
                                            </li>

                                            <li>Main Treatment Process

                                                <ul class="list-sign">
                                                    <li>Vamanam ( Emesis)</li>
                                                    <li>Virechanam (Purgation)</li>
                                                    <li>
                                                        Vasti (Medicated enema)
                                                        <ul >
                                                            <li>Asthapanam Vasti</li>
                                                            <li>Anuvasanam Vasti</li>
                                                        </ul>
                                                    </li>

                                                    <li>Nasyam ( Nasal Insufflation)</li>
                                                </ul>
                                            </li>

                                        </ul>
                                    </li>
                                </ul>
                                <p>The cost of the treatment varies between INR 1000.00 to INR 3500.00 per person per
                                    session. The cost to the company would be between 15-25% of the Service cost. The
                                    rest is the profit to the center.</p>
                            </li>
                        </ul>

                        <h4>3) Why “Kerala Ayurveda Center” is Unique?</h4>
                        <ul class="list-disc">
                            <li>BRAND VALUE: Trusted brand for over 25 years and recognized as pioneers in
                                providing traditional healing to the masses.</li>
                            <li>LEADERSHIP: Kerala Ayurveda Center is recognized as front runner in
                                Ayurvedic Health Resorts,Wellness Spas and Therapeutic Center in India and
                                Abroad</li>
                            <li>VAST EXPERIENCE: Three generations put their heart and soul for over 80
                                years ofdedicated service and promotion of Ayurveda throughout India and
                                across world.</li>
                            <li>SUNRISE BUSINESS MODEL: Kerala Ayurveda Center has been providing a
                                very successful business model to our esteemed franchisees and Associates,
                                where goodwill, quality and financial returns are all go hand in hand.
                            </li>
                            <li>CONTINUOUS R & D: R& D assures quality and efficacy in treatments and
                                patient support</li>
                            <li>EQUIPMENTS: Handcrafted equipment’s to support therapy.</li>
                        </ul>

                        <h4>4) Who is Kerala Ayurveda Center’s Competitor?
                        </h4>
                        <ul class="list-disc">
                            <li>Birla Ayurveda</li>
                            <li>Baidyanath</li>
                            <li>Patanjali</li>
                            <li>Kottakkal Arya Vaidya Shala</li>
                            <li>Kerala Ayurveda Ltd.</li>
                        </ul>

                        <h4>5) Who all are the target audience?</h4>
                         <ul class="list-disc">
                            <li>People with age group of 40 plus are our target audience.</li>
                            <li>People with different ailments
                            </li>
                            <li>People who need relaxation therapies are also targeted</li>
                         </ul>

                         <h4>6) What is the training required for this project?</h4>
                         <p>There is no training required for the top management. Trained staff would be provided
                            by our end. This works similarly to any hospitality sector. At the management level, we
                            can provide training at an additional cost.
                            </p>

                        <h4>7) Number of staff required for running this project?</h4>
                        <p>The staff structure for a 2 treatment room would be as under:</p>
                        <ul>
                            <li>2 Male Therapists</li>
                            <li>2 Female Therapists</li>
                            <li>1 Spa manager/ Ayurveda Doctor</li>
                            <li>House Keeping staff</li>
                            <li>Receptionist/ Guest Reception Executive</li>
                        </ul>

                        <h4>8) What are the salaries to be paid to the staff?</h4>
                        <p>Each staffis paid directly by the franchise center. Approximate salary charges are follows:</p>
                        <ul>
                            <li>Per Therapist - INR 18000.00</li>
                            <li>Doctor - INR 40000.00</li>
                        </ul>

                        <h4>9) Do I have any other obligations towards the staff?</h4>
                        <p>Yes, since the staff is moving to your location our franchisee is responsible for their food
                            and accommodation. It is also recommended to provide to the doctor a separate
                            accommodation, whereas the therapist may not share the same accommodation.</p>

                      <h4>10) What is the time line required to set up a center?</h4>
                      <p>The time line to set up a center is around 60 – 90 days. The staff is trained at our
                        Resort located in Palakkad, Kerala for approximately 30 days and equipment
                        manufacturing requires 45 days aswell.
                        </p>

                        <h4>11) What is my capital investment towards this project?</h4>
                        <p>To establish a Two room Center, it would require an initial investment of Rs.
                            2000000.00 approximately which includes</p>

                            <ul class="list-disc" >
                                <li>Interior Design Budget: Rs. 600000.00 Approx</li>
                                <li>Equipment’s: Rs. 600000.00 Approx</li>
                                <li>Technical Service fees Rs. 500000.00.                                </li>
                                <li>Miscellaneous Expenses: Rs. 300000.00 Approx.</li>
                            </ul>

                            <h4>12) How much working capital is required before we can be self-sufficient?</h4>
                            <p>For any new venture we would suggest at least to keep 6 months of additional working
                                capital in hand. Approximately INR 500000.00 per month for six months to be safer &
                                smooth running.</p>

                           <h4>13) What will be the expected profit margin?</h4>
                           <p>The profit margin varies from place to place. But as far as our experience goes the first
                            year return on investment would be 29% at an efficiency of 30% occupancy.</p>

                        <h4>14) What is the launch plan to ensure maximum awareness fromDay One?</h4>
                        <p>Above The Line Activities Budget are to be maintained by Client, Activities like –</p>
                        <ul class="list-disc">
                            <li>Promotion through Radio</li>
                            <li>Shelters</li>
                            <li>Bus holdings</li>
                        </ul>

                        <h4>15) What kind of construction and ambience would be required for this project? Is
                            thereany blue print available?</h4>

                        <p>We provide technical input to any space that may be provided to us. Interior layout and
                            specification will be provided to the client through our in house architects. Cost
                            implications for the interiors are specified in our investment section approximately for
                            your budgeting purpose only as they very from place to place.
                            </p>

                        <h4>16)How Kerala Ayurveda Center</h4>
                        <p>Our Head Office will look after Below the Line Activities to promote awareness like:
                        </p>
                        <ul class="list-disc">
                            <li>Articles in Magazines & Newspapers</li>
                            <li>Website maintenance for Kerala Ayurveda Center & Products</li>
                            <li>Adds for Your Centers in Magazines</li>
                            <li>Flyers will be provided quarterly to be distributed locally</li>
                            <li>Promotion through you tube</li>
                            <li>Maintenance of Facebook & Twitter Account</li>
                        </ul>

                        <h4>17) Product profile & range?</h4>
                        <p>We supply all spa products, herbal cosmetics, ayurvedic classical medicines, researched
                            patentedproducts. We also offer an excellent discount on our retail spa products. They
                            all are manufactured in our own pharmaceutical units in India and the Products are
                            available only to ourfranchise.</p>

                            <h4>18)What are the different Products Segments of Kerala Ayurveda Center?</h4>
                            <ul class="list-disc">
                                <li>Kerala Ayurveda Oil Products</li>
                                <li>Kerala Ayurveda Patent Products</li>
                                <li>Kerala Ayurveda Patent Oil Products</li>
                                <li>Kerala Ayurveda Classical Products</li>
                                <li>In all 150 Products</li>
                            </ul>

                            <h4>19) Is there any Royalty?</h4>
                            <p>Yes, there is a royalty of 5% on net monthly sales or INR 25,000.00 plus applicable taxes
                                per month (whichever is higher). This will in turn be spent on your marketing plus
                                branding your Center at all various exhibition and media publication</p>
                    </ol>


                </div>
            </div>
        </div>
    </div>


</body>

</html>
<?php /**PATH /home/keralaayurvedace/public_html/franchise/resources/views/pdf/2room_template.blade.php ENDPATH**/ ?>