<?php $__env->startSection('title'); ?>
    <title>Application Status</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-main__outer">
        <div class="app-main__inner">
            <div class="row">
                <div class="col-md-12">
                    <div class="main-card mb-3 card">
                        <div class="card-body">
                            <h5 class="card-title">Application Status</h5>

                            <?php if($user->kyc_verification_status === 'approved'): ?>
                                <div class="alert alert-success" role="alert">
                                    Your KYC document has been verified successfully!
                                </div>
                            <?php elseif($user->kyc_verification_status === 'rejected'): ?>
                                <div class="alert alert-danger" role="alert">
                                    Your KYC document has been rejected. Please re-submit.
                                </div>
                            <?php else: ?>
                                <div class="alert alert-warning" role="alert">
                                    <?php if($user->adhar_no && $user->pancard_no): ?>
                                        Your KYC document (Aadhar: <?php echo e($user->adhar_no); ?>, Pan Card: <?php echo e($user->pancard_no); ?>)
                                        is uploaded and pending for approval.
                                    <?php else: ?>
                                        Your KYC document is pending for submission.
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <?php if($user->kyc_verification_status === 'approved' && $user->application_no): ?>
                                <div class="alert alert-info" role="alert">
                                    Your application number: <?php echo e($user->application_no); ?>

                                </div>
                            <?php endif; ?>

                            <?php if(isset($error)): ?>
                                <p class="text-danger"><?php echo e($error); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/keralaayurvedace/public_html/franchise/resources/views/user/dashboard/pages/application_status.blade.php ENDPATH**/ ?>