@extends('superAdmin.layouts.master')

@section('title')
    <title>All Approved Users</title>
@endsection

@section('content')
    <div class="app-main__inner">
        <div class="app-page-title">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="pe-7s-id icon-gradient bg-mean-fruit">
                        </i>
                    </div>
                    <div>All Admin
                        <div class="page-title-subheading">
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="main-card mb-3 card">
                    <div class="card-header">ALL Franhise
                        <div class="btn-actions-pane-right">

                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="align-middle mb-0 table table-borderless table-striped table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center">#</th>
                                    <th>Name</th>
                                    <th class="text-center">City</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($adminUser as $item)
                                    <tr>
                                        <td class="text-center text-muted">{{$item->id}}</td>
                                        <td>
                                            <div class="widget-content p-0">
                                                <div class="widget-content-wrapper">

                                                    <div class="widget-content-left flex2">
                                                        <div class="widget-heading">{{ $item->name }}</div>

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">{{ $item->city ?? 'NA' }}</td>
                                        <td class="text-center">
                                            <div class="badge badge-warning">{{ $item->status }}</div>
                                        </td>
                                        <td class="text-center">
                                            @if ($item->status == 'pending')
                                            <form method="POST" action="{{ route('admin.activate', ['id' => $item->id]) }}" style="display: inline;">
                                                @csrf
                                                <button type="submit" class="mb-2 mr-2 btn-transition btn btn-outline-danger">Activate</button>
                                            </form>
                                            @else
                                            <form method="POST" action="{{ route('admin.deactivate', ['id' => $item->id]) }}" style="display: inline;">
                                                @csrf
                                                <button type="submit" class="mb-2 mr-2 btn-transition btn btn-outline-danger">Deactivate</button>
                                            </form>
                                            @endif

                                            <a href="{{route('assign.application', ['id' => $item->id])}}" class="btn btn-primary">Assign Application</a>
                                            <a href="{{route('delete.application', ['id' => $item->id])}}" class="btn btn-primary">Delete Application</a>
                                            {{-- <a href="{{route('assigned.application', ['id' => $item->id])}}" class="btn btn-primary">Show Assigned Application</a> --}}
                                        </td>
                                    </tr>
                                @endforeach


                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
