<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = \Faker\Factory::create();

        $password = '111';
        // Super Admin
        $userId = DB::table('users')->insertGetId([
            'name' => 'Super Admin',
            'username' => 'superadmin',
            'email' => 'superadmin@gmail.com',
            'password' => Hash::make($password),
            'role' => 'super_admin',
            'status' => 'approved',
            'cred' => Crypt::encrypt($password)
        ]);

        // Admin
        $userId = DB::table('users')->insertGetId([
            'name' => 'Admin',
            'username' => 'admin',
            'email' => 'admin@gmail.com',
            'password' => Hash::make($password),
            'role' => 'admin',
            'status' => 'approved',
            'cred' => Crypt::encrypt($password)
        ]);

        // Insert profile data using the obtained user ID
        DB::table('profiles')->insert([
            'user_id' => $userId,
            'city' => $faker->city,
        ]);

        // Franchise
        $userId = DB::table('users')->insertGetId([
            'name' => 'Franchise',
            'username' => 'franchise',
            'email' => 'franchise@gmail.com',
            'password' => Hash::make($password),
            'role' => 'franchise',
            'status' => 'approved',
            'cred' => Crypt::encrypt($password)
        ]);

        DB::table('profiles')->insert([
            'user_id' => $userId,
            'city' => $faker->city,
        ]);

        // Another Franchise with 'pending' status
        $userId = DB::table('users')->insertGetId([
            'name' => 'Franchise1',
            'username' => 'franchise1',
            'email' => 'franchise1@gmail.com',
            'password' => Hash::make($password),
            'role' => 'franchise',
            'status' => 'pending',
            'cred' => Crypt::encrypt($password)
        ]);

        DB::table('profiles')->insert([
            'user_id' => $userId,
            'city' => $faker->city,
        ]);
    }
}
