<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Hash;

class FranchiseUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
         // Use the Faker library to generate random data
         $faker = \Faker\Factory::create();

         // Define the number of users you want to create
         $numberOfUsers = 150;

         // Loop to create users
        for ($i = 0; $i < $numberOfUsers; $i++) {
            $password = Str::random(10);

            // Insert user data and get the user ID
            $userId = DB::table('users')->insertGetId([
                'name' => $faker->name,
                'email' => $faker->unique()->safeEmail,
                'password' => Hash::make($password),
                'role' => 'franchise',
                'cred' => Crypt::encrypt($password),
            ]);

            // Insert profile data using the obtained user ID
            DB::table('profiles')->insert([
                'user_id' => $userId,
                'city' => $faker->city,
                'franchise_type' => $faker->randomElement(['2room', '4room']),
            ]);
        }
    }
}

