<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assigned_applications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constraint('user');
            $table->string('admin_id')->nullable();
            $table->string('application_id')->nullable();
            $table->string('application_no')->nullable();
            $table->boolean('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assigned_applications');
    }
};
