<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained();
            $table->string('nationality')->nullable();
            $table->string('education')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('pincode')->nullable();
            $table->string('work_no')->nullable();
            $table->string('website')->nullable();
            $table->string('business_city')->nullable();
            $table->string('business_state')->nullable();
            $table->string('business_pincode')->nullable();
            $table->string('know_about_center')->nullable();
            $table->enum('industry_exp', ['yes', 'no'])->default('no');
            $table->string('experience_desc')->nullable();
            $table->enum('partnership_type', ['yes', 'no'])->default('no');
            $table->string('partner_dtl')->nullable();
            $table->string('current_earning')->nullable();
            $table->string('current_asset_holding')->nullable();
            $table->string('money_invest')->nullable();
            $table->string('space')->nullable();
            $table->enum('franchise_type', ['2room', '4room'])->nullable();
            $table->string('pdf_link')->nullable();
            $table->enum('prop_type', ['lease', 'rent', 'owned'])->default('rent');
            $table->string('signature_img')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profiles');
    }
};
