<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('username')->nullable();
            $table->string('email')->unique();
            $table->string('application_no')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('mobile_no')->nullable();
            $table->string('whatsapp_no')->nullable();
            $table->string('address')->nullable();
            $table->string('photo')->nullable();
            $table->enum('role', ['franchise', 'admin', 'super_admin'])->default('franchise');
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->string('adhar_no')->nullable();
            $table->string('pancard_no')->nullable();
            $table->enum('kyc__verification_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->boolean('adminAssignStatus')->default(0);
            $table->string('cred');
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
