<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;
use App\Models\User;
USE App\Models\Profile;

class SellerController extends Controller
{
    public function dashboard(){
        return view('user.dashboard.pages.dashboard');
    }

    public function applicationStatus()
{
    $user = Auth::user();

    // return $user;

    return view('user.dashboard.pages.application_status', compact('user'));
}


    public function sellerLogout(Request $request){
        Auth::logout();

        return redirect('/');
    }

    public function uploadDocument(){
        $user = Auth::user();
        return view('user.dashboard.pages.kyc_upload', compact('user'));
    }

    public function storeKyc(Request $request){
    // Validate the request

    $request->validate([
        'adhar_no' => [
            'required',
            'string',
            'regex:/^\d{12}$/',
            Rule::unique('users')->ignore(Auth::id()),
        ],
        'pancard_no' => [
            'required',
            'string',
            'regex:/^([a-zA-Z]){5}([0-9]){4}([a-zA-Z]){1}?$/',
            Rule::unique('users')->ignore(Auth::id()),
        ],
    ]);

        $user = Auth::user();

        $user->update([
            'adhar_no' => $request->adhar_no,
            'pancard_no' => $request->pancard_no,
        ]);

        return redirect()->route('dashboard')->with('message', 'KYC details updated successfully. It is pending verification.');
    }


    public function updatePasswordForm(){
        return view('user.dashboard.pages.update_password');
    }

    public function updatePassword(Request $request){

        $request->validate([
            'current_password' => 'required',
            'new_password' => 'required|min:8|confirmed',
        ]);

        $user = Auth::user();
        if (Hash::check($request->current_password, $user->password)) {
            // Update the user's password
            $user->update([
                'password' => Hash::make($request->new_password),
            ]);

            // Redirect with success message
            return redirect()->route('update.password')->with('status', 'Password updated successfully!');
        } else {
            // Redirect with error message
            return redirect()->route('update.password')->with('error', 'Incorrect current password. Please try again.');
        }
    }

    public function updateBasicForm(){
        $user = Auth::user();

        $profile = $user->profile;


        return view('user.dashboard.pages.update_basic_details', compact('user', 'profile'));
    }

    public function updateBasicDetails(Request $request){


    $user = Auth::user();
    // Update User Details
    $user->name = $request->input('name');
    $user->username = $request->input('username');
    $user->address = $request->input('address');
    $user->mobile_no = $request->input('mobile_no');
    $user->whatsapp_no = $request->input('whatsapp_no');
    $user->email = $request->input('email');

    // Handle photo upload
    if ($request->hasFile('photo')) {
        $photoFile = $request->file('photo');
        $photoPath = 'uploads/users/' . $photoFile->getClientOriginalName();

        $photoFile->move(public_path('uploads/users/'), $photoPath);

        $user->photo = $photoPath;
    }

    $user->save();

    // Update or Create Profile Details
    $profile = $user->profile ?? new Profile();
    $profile->nationality = $request->input('nationality');
    $profile->education = $request->input('education');
    $profile->city = $request->input('city');
    $profile->state = $request->input('state');
    $profile->pincode = $request->input('pincode');
    $profile->work_no = $request->input('work_no');
    $profile->website = $request->input('website');
    $profile->business_city = $request->input('business_city');
    $profile->business_state = $request->input('business_state');
    $profile->business_pincode = $request->input('business_pincode');
    $profile->know_about_center = $request->input('know_about_center');
    $profile->industry_exp = $request->input('industry_exp');
    $profile->experience_desc = $request->input('experience_desc');
    $profile->partnership_type = $request->input('partnership_type');
    $profile->partner_dtl = $request->input('partner_dtl');
    $profile->current_earning = $request->input('current_earning');
    $profile->current_asset_holding = $request->input('current_asset_holding');
    $profile->money_invest = $request->input('money_invest');
    $profile->space = $request->input('space');
    $profile->prop_type = $request->input('prop_type');
    $franchiseType = $profile->franchise_type;

    if ($request->hasFile('signature_img')) {
        $photoFile = $request->file('signature_img');
        $photoPath = 'uploads/signatures/' . $photoFile->getClientOriginalName();

        $photoFile->move(public_path('uploads/signatures/'), $photoPath);

        $profile->signature_img = $photoPath;
    }


    $user->profile()->save($profile);

    return redirect()->route('dashboard')->with('message', 'Basic details updated successfully!');
}


public function pdfView(){
    return "12";
    return view('pdf.2room_template');

}

}
