<?php

namespace App\Http\Controllers;
use App\Events\KycDocumentVerified;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Notification;
use App\Notifications\ApplicationRejected;
use Illuminate\Support\Facades\Crypt;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\EnquiryExport;
use App\Models\AssignedApplication;


class AdminController extends Controller
{

    public function adminDashboard(){
        $adminId = auth()->user()->id;

        // Count total assigned applications for the admin
        $totalUsers = assignedApplication::where('admin_id', $adminId)
            ->where('status', 1)
            ->count();

        // Count active, pending, and rejected assigned applications for the admin
        $activeUsers = AssignedApplication::where('admin_id', $adminId)
            ->where('status', 1)
            ->whereHas('user', function ($query) {
                $query->where('status', 'active');
            })
            ->count();

        $pendingUsers = AssignedApplication::where('admin_id', $adminId)
            ->where('status', 1)
            ->whereHas('user', function ($query) {
                $query->where('status', 'pending');
            })
            ->count();

        $rejectedUsers = AssignedApplication::where('admin_id', $adminId)
            ->where('status', 1)
            ->whereHas('user', function ($query) {
                $query->where('status', 'rejected');
            })
            ->count();

        // Fetch the latest assigned applications
        $latestApplications = AssignedApplication::with(['user.profile' => function ($query) {
                $query->select('user_id', 'city');
            }])
            ->where('admin_id', $adminId)
            ->where('status', 1)
            ->orderBy('created_at', 'desc')
            ->take(10)
            ->get(['id', 'user_id', 'application_id', 'status']);

        return view('admin.pages.dashboard', compact('totalUsers', 'activeUsers', 'pendingUsers', 'rejectedUsers', 'latestApplications'));
    }

    public function showUserDetails($id)
    {
        $user = User::with('profile')->find($id);
        $encryptedPassword = $user->cred;
        $password = Crypt::decrypt($encryptedPassword);

    if (!$user) {
        return abort(404);
    }

    return view('admin.pages.user_datails', compact('user', 'password'));
    }



    public function approveUser($id) {

        // Find the user by ID
        $user = User::findOrFail($id);

        // Check if the user has a kyc_document
        if ($user->pancard_no && $user->adhar_no) {
            // Update kyc_verification_status to 'approved' and Status 'approved
            DB::transaction(function () use ($user) {
                $user->update(
                    [
                        'kyc__verification_status' => 'approved',
                        'status' => 'approved'
                    ]);

                // Dispatch the event to generate application number
                event(new KycDocumentVerified($user));
            });

            return redirect()->route('admin.dashboard')->with('message', 'User approved successfully!');
        } else {
            // If the user doesn't have a kyc_document, handle accordingly
            return redirect()->back()->with('error', 'User cannot be approved without pan card & adhar card no.');
        }
    }


    public function pedingUser($id){
        $user = User::findOrFail($id);

        $user->update([
            'status' => 'pending'
        ]);

        return redirect()->route('admin.dashboard')->with('message', 'Franchise Status has been Pending');

    }

    public function rejectUser($id) {
        $user = User::findOrFail($id);

        // Notification::send($user, new ApplicationRejected);

        $user->update([
            'adhar_no' => null,
            'pancard_no' => null,
            'status' => 'rejected'
        ]);

        return redirect()->route('admin.dashboard')->with('message', 'User rejected successfully!');
    }


    public function allApprovedUser(){

        $adminId = auth()->user()->id;

        $approvedUsers = AssignedApplication::with(['user.profile' => function ($query) {
            $query->select('user_id', 'city');
        }])
        ->where('admin_id', $adminId)
        ->where('status', 1)
        ->whereHas('user', function ($query) {
            $query->where('kyc__verification_status', 'approved');
        })
        ->orderBy('created_at', 'desc')
        ->take(10)
        ->get(['id', 'user_id', 'application_id', 'status']);

        // return $approvedUsers;
        return view('admin.pages.approved_users', compact('approvedUsers'));
    }


    public function allPendingdUser(){

        $adminId = auth()->user()->id;

        $pendingUser = AssignedApplication::with(['user.profile' => function ($query) {
            $query->select('user_id', 'city');
        }])
        ->where('admin_id', $adminId)
        ->where('status', 1)
        ->whereHas('user', function ($query) {
            $query->where('kyc__verification_status', 'pending');
        })
        ->orderBy('created_at', 'desc')
        ->take(10)
        ->get(['id','user_id', 'application_id', 'status']);

        // return $pendingUser;

        return view('admin.pages.pending_users', compact('pendingUser'));
    }

    public function allRejectedUser(){
        $adminId = auth()->user()->id;

        $rejectedUser = AssignedApplication::with(['user.profile' => function ($query) {
            $query->select('id', 'user_id', 'city');
        }])
        ->where('admin_id', $adminId)
        ->where('status', 1)
        ->whereHas('user', function ($query) {
            $query->where('kyc__verification_status', 'rejected');
        })
        ->orderBy('created_at', 'desc')
        ->take(10)
        ->get(['id', 'user_id', 'application_id', 'status']);

        // return $rejectedUser;

        return view('admin.pages.rejected_users', compact('rejectedUser'));
    }

    public function enquiryData(){
        $enquiry = User::where('role', '!=', 'admin')->get();
        return view('admin.pages.enquiry', compact('enquiry'));
    }

    public function adminLogout () {
        Auth::logout();
        return redirect('/')->with('message', 'Your account has been Logged out');
    }

    public function exportEnquiry(){
        return Excel::download(new EnquiryExport, 'enquiry.xlsx');
    }


}
