<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;

use Maatwebsite\Excel\Concerns\WithHeadings;

class EnquiryExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return User::select('name', 'email', 'mobile_no', 'whatsapp_no', 'address')
        ->where('role', '!=', 'admin')->get();
    }

    public function headings(): array
    {
        return [
            'Name',
            'Email',
            'Mobile No',
            'Whatsapp No',
            'Address',
        ];
    }
}
